/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.api;

import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import org.jetbrains.annotations.ApiStatus;

public interface EnchantmentStatBlock
extends IBlockExtension {
    @ApiStatus.OverrideOnly
    default public float getMaxEnchantingPower(BlockState state, LevelReader world, BlockPos pos) {
        return 30.0f;
    }

    @ApiStatus.OverrideOnly
    default public float getQuantaBonus(BlockState state, LevelReader world, BlockPos pos) {
        return 0.0f;
    }

    @ApiStatus.OverrideOnly
    default public float getArcanaBonus(BlockState state, LevelReader world, BlockPos pos) {
        return 0.0f;
    }

    @ApiStatus.OverrideOnly
    default public int getBonusClues(BlockState state, LevelReader world, BlockPos pos) {
        return 0;
    }

    default public Set<Enchantment> getBlacklistedEnchantments(BlockState state, LevelReader world, BlockPos pos) {
        return Collections.emptySet();
    }

    default public void spawnTableParticle(BlockState state, Level level, RandomSource rand, BlockPos pos, BlockPos offset) {
        if (rand.nextInt(16) == 0 && EnchantingStatRegistry.getEterna(level.getBlockState(pos.offset((Vec3i)offset)), level, pos.offset((Vec3i)offset)) > 0.0f && level.isEmptyBlock(pos.offset(offset.getX() / 2, 0, offset.getZ() / 2))) {
            level.addParticle(this.getTableParticle(state), (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)offset.getX() + rand.nextFloat()) - 0.5, (double)((float)offset.getY() - rand.nextFloat() - 1.0f), (double)((float)offset.getZ() + rand.nextFloat()) - 0.5);
        }
    }

    default public ParticleOptions getTableParticle(BlockState state) {
        return ParticleTypes.ENCHANT;
    }

    default public boolean allowsTreasure(BlockState state, LevelReader world, BlockPos pos) {
        return false;
    }

    default public boolean providesStability(BlockState state, LevelReader world, BlockPos pos) {
        return false;
    }
}

