/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.compat;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.objects.FilteringShelfBlock;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class EnchHwylaPlugin
implements IWailaPlugin,
IBlockComponentProvider {
    public void registerClient(IWailaClientRegistration reg) {
        reg.registerBlockComponent((IBlockComponentProvider)this, Block.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        TooltipUtil.appendBlockStats(accessor.getLevel(), accessor.getBlockState(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
        if (accessor.getBlock() == Blocks.ENCHANTING_TABLE) {
            TooltipUtil.appendTableStats(accessor.getLevel(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
            tooltip.remove(Identifiers.MC_TOTAL_ENCHANTMENT_POWER);
        }
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF.get()) {
            this.handleFilteringShelf(tooltip, accessor);
        }
    }

    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF.get()) {
            return IElementHelper.get().item(accessor.getPickedResult());
        }
        return currentIcon;
    }

    public ResourceLocation getUid() {
        return ApothicEnchanting.loc("ench");
    }

    public int getDefaultPriority() {
        return 1150;
    }

    public void handleFilteringShelf(ITooltip tooltip, BlockAccessor accessor) {
        tooltip.remove(Identifiers.MC_ENCHANTMENT_POWER);
        tooltip.remove(Identifiers.MC_CHISELED_BOOKSHELF);
        tooltip.remove(Identifiers.UNIVERSAL_ITEM_STORAGE);
        if (accessor.showDetails()) {
            return;
        }
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof FilteringShelfBlock.FilteringShelfTile) {
            FilteringShelfBlock.FilteringShelfTile tile = (FilteringShelfBlock.FilteringShelfTile)blockEntity;
            Optional optional = ChiseledBookShelfBlock.getRelativeHitCoordinatesForBlockFace((BlockHitResult)((BlockHitResult)accessor.getHitResult()), (Direction)((Direction)accessor.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)));
            if (optional.isEmpty()) {
                return;
            }
            int slot = ChiseledBookShelfBlock.getHitSlot((Vec2)((Vec2)optional.get()));
            ItemStack stack = tile.getItem(slot);
            if (stack.isEmpty()) {
                return;
            }
            tooltip.add(CommonComponents.EMPTY);
            IElementHelper helper = IElementHelper.get();
            ArrayList<IElement> elements = new ArrayList<IElement>();
            elements.add(helper.smallItem(stack).clearCachedMessage());
            elements.add(helper.text((Component)Component.literal((String)" ").append((Component)Component.literal((String)IDisplayHelper.get().humanReadableNumber((double)stack.getCount(), "", false)).append("\u00d7 ").append(stack.getHoverName()))).message(null));
            tooltip.add(elements);
            if (stack.getTag() != null && stack.getTag().contains("StoredEnchantments")) {
                ArrayList list = new ArrayList();
                ItemStack.appendEnchantmentNames(list, (ListTag)EnchantedBookItem.getEnchantments((ItemStack)stack));
                for (Component c : list) {
                    tooltip.add((Component)Component.literal((String)" - ").append(c));
                }
            }
        }
    }
}

