/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class NaturesBlessingEnchant
extends Enchantment {
    public NaturesBlessingEnchant() {
        super(Enchantment.Rarity.RARE, ApothicEnchanting.HOE, new EquipmentSlot[0]);
    }

    public boolean canEnchant(ItemStack stack) {
        return stack.getItem() instanceof HoeItem;
    }

    public int getMaxLevel() {
        return 3;
    }

    public int getMinCost(int level) {
        return 25 + level * 10;
    }

    public int getMaxCost(int level) {
        return 200;
    }

    public void rightClick(PlayerInteractEvent.RightClickBlock e) {
        ItemStack s = e.getItemStack();
        int nbLevel = s.getEnchantmentLevel((Enchantment)this);
        if (!e.getEntity().isShiftKeyDown() && nbLevel > 0 && BoneMealItem.applyBonemeal((ItemStack)s.copy(), (Level)e.getLevel(), (BlockPos)e.getPos(), (Player)e.getEntity())) {
            s.hurtAndBreak(Math.max(1, 6 - nbLevel), (LivingEntity)e.getEntity(), ent -> ent.broadcastBreakEvent(e.getHand()));
            e.setCanceled(true);
            e.setCancellationResult(InteractionResult.SUCCESS);
        }
    }
}

