/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;

public class ReboundingEnchant
extends Enchantment {
    public ReboundingEnchant() {
        super(Enchantment.Rarity.RARE, ApothicEnchanting.CORE_ARMOR, new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.LEGS});
    }

    public int getMaxLevel() {
        return 3;
    }

    public int getMinCost(int level) {
        return 22 + (level - 1) * 18;
    }

    public int getMaxCost(int level) {
        return 200;
    }

    public void doPostHurt(LivingEntity user, Entity attacker, int level) {
        if (attacker != null && user.distanceToSqr(attacker) <= 4.0 && attacker.canChangeDimensions()) {
            level = EnchantmentHelper.getEnchantmentLevel((Enchantment)this, (LivingEntity)user);
            Vec3 vec = new Vec3(attacker.getX() - user.getX(), attacker.getY() - user.getY(), attacker.getZ() - user.getZ());
            attacker.push(vec.x * 2.0 * (double)level, vec.y * 3.0 * (double)level, vec.z * 2.0 * (double)level);
        }
    }
}

