/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.event.entity.living.ShieldBlockEvent;

public class ReflectiveEnchant
extends Enchantment {
    public ReflectiveEnchant() {
        super(Enchantment.Rarity.RARE, ApothicEnchanting.SHIELD, new EquipmentSlot[]{EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND});
    }

    public int getMinCost(int enchantmentLevel) {
        return enchantmentLevel * 18;
    }

    public int getMaxCost(int enchantmentLevel) {
        return 200;
    }

    public int getMaxLevel() {
        return 5;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack) || stack.canPerformAction(ToolActions.SHIELD_BLOCK);
    }

    public void reflect(ShieldBlockEvent e) {
        LivingEntity user = e.getEntity();
        Entity attacker = e.getDamageSource().getDirectEntity();
        ItemStack shield = user.getUseItem();
        int level = shield.getEnchantmentLevel((Enchantment)this);
        if (level > 0 && user.level().random.nextInt(Math.max(2, 7 - level)) == 0) {
            DamageSource src = user.level().damageSources().indirectMagic((Entity)user, (Entity)user);
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                livingAttacker.hurt(src, (float)level * 0.15f * e.getBlockedDamage());
                shield.hurtAndBreak(10, user, ent -> ent.broadcastBreakEvent(EquipmentSlot.OFFHAND));
            }
        }
    }
}

