/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.ToolActions;

public class ShieldBashEnchant
extends Enchantment {
    public ShieldBashEnchant() {
        super(Enchantment.Rarity.RARE, ApothicEnchanting.SHIELD, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int getMinCost(int enchantmentLevel) {
        return 1 + (enchantmentLevel - 1) * 17;
    }

    public int getMaxCost(int enchantmentLevel) {
        return this.getMinCost(enchantmentLevel) + 40;
    }

    public int getMaxLevel() {
        return 4;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack) || stack.canPerformAction(ToolActions.SHIELD_BLOCK);
    }

    public float getDamageBonus(int pLevel, MobType pType) {
        return 3.5f * (float)pLevel;
    }

    public void doPostAttack(LivingEntity user, Entity target, int level) {
        ItemStack stack;
        if (target instanceof LivingEntity && (stack = user.getMainHandItem()).getEnchantmentLevel((Enchantment)this) == level) {
            stack.hurtAndBreak(Math.max(1, 20 - level), user, e -> e.broadcastBreakEvent(EquipmentSlot.OFFHAND));
        }
    }

    protected boolean checkCompatibility(Enchantment pOther) {
        return super.checkCompatibility(pOther) && !(pOther instanceof DamageEnchantment);
    }
}

