/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.corrupted;

import dev.shadowsoffire.apothic_enchanting.compat.CuriosCompat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;

public class LifeMendingEnchant
extends Enchantment {
    private static final EquipmentSlot[] SLOTS = EquipmentSlot.values();

    public LifeMendingEnchant() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.BREAKABLE, EquipmentSlot.values());
    }

    public int getMinCost(int level) {
        return 65 + (level - 1) * 35;
    }

    public int getMaxCost(int level) {
        return this.getMinCost(level) + 50;
    }

    public int getMaxLevel() {
        return 3;
    }

    public boolean isCurse() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack) || stack.canPerformAction(ToolActions.SHIELD_BLOCK);
    }

    protected boolean checkCompatibility(Enchantment pOther) {
        return super.checkCompatibility(pOther) && pOther != Enchantments.MENDING;
    }

    public Component getFullname(int level) {
        return ((MutableComponent)super.getFullname(level)).withStyle(ChatFormatting.DARK_RED);
    }

    private boolean lifeMend(LivingHealEvent e, ItemStack stack) {
        if (!stack.isEmpty() && stack.isDamaged()) {
            int level = stack.getEnchantmentLevel((Enchantment)this);
            if (level <= 0) {
                return false;
            }
            float cost = 1.0f / (float)(1 << level - 1);
            int maxRestore = Math.min(Mth.floor((float)(e.getAmount() / cost)), stack.getDamageValue());
            e.setAmount(e.getAmount() - (float)maxRestore * cost);
            stack.setDamageValue(stack.getDamageValue() - maxRestore);
            return true;
        }
        return false;
    }

    public void lifeMend(LivingHealEvent e) {
        if (e.getEntity().level().isClientSide) {
            return;
        }
        float amt = e.getAmount();
        if (amt <= 0.0f) {
            return;
        }
        for (EquipmentSlot slot : SLOTS) {
            ItemStack stack = e.getEntity().getItemBySlot(slot);
            if (!this.lifeMend(e, stack)) continue;
            return;
        }
        if (ModList.get().isLoaded("curios")) {
            List<ItemStack> stacks = CuriosCompat.getLifeMendingCurios(e.getEntity());
            for (ItemStack stack : stacks) {
                if (!this.lifeMend(e, stack)) continue;
                return;
            }
        }
    }
}

