/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.masterwork;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.util.MiscUtil;
import dev.shadowsoffire.placebo.util.PlaceboTaskQueue;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.event.level.BlockEvent;

public class ChainsawEnchant
extends Enchantment {
    public ChainsawEnchant() {
        super(Enchantment.Rarity.VERY_RARE, ApothicEnchanting.AXE, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMinCost(int level) {
        return 55;
    }

    public int getMaxCost(int enchantmentLevel) {
        return 200;
    }

    public Component getFullname(int level) {
        return ((MutableComponent)super.getFullname(level)).withStyle(ChatFormatting.DARK_GREEN);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.canPerformAction(ToolActions.AXE_DIG) || super.canApplyAtEnchantingTable(stack);
    }

    public void chainsaw(BlockEvent.BreakEvent e) {
        Player player = e.getPlayer();
        Level level = player.level();
        ItemStack stack = player.getMainHandItem();
        int enchLevel = stack.getEnchantmentLevel((Enchantment)this);
        if (player.getClass() == ServerPlayer.class && enchLevel > 0 && !level.isClientSide && this.isTree(level, e.getPos(), e.getState()) && !player.getAbilities().instabuild) {
            PlaceboTaskQueue.submitTask((String)"apotheosis:chainsaw_task", (BooleanSupplier)new ChainsawTask(player.getUUID(), stack, level, e.getPos()));
        }
    }

    private boolean isTree(Level level, BlockPos pos, BlockState state) {
        if (!state.is(BlockTags.LOGS)) {
            return false;
        }
        while (state.is(BlockTags.LOGS)) {
            pos = pos.above();
            state = level.getBlockState(pos);
        }
        for (BlockPos p : BlockPos.betweenClosed((BlockPos)pos.offset(-2, -2, -2), (BlockPos)pos.offset(2, 2, 2))) {
            if (!level.getBlockState(p).is(BlockTags.LEAVES)) continue;
            return true;
        }
        return false;
    }

    private static class ChainsawTask
    implements BooleanSupplier {
        UUID owner;
        ItemStack axe;
        ServerLevel level;
        Int2ObjectMap<Queue<BlockPos>> hits = new Int2ObjectOpenHashMap();
        int ticks = 0;

        public ChainsawTask(UUID owner, ItemStack axe, Level level, BlockPos pos) {
            this.owner = owner;
            this.axe = axe;
            this.level = (ServerLevel)level;
            ((Queue)this.hits.computeIfAbsent(pos.getY(), i -> new ArrayDeque())).add(pos);
        }

        @Override
        public boolean getAsBoolean() {
            if (++this.ticks % 2 != 0) {
                return false;
            }
            if (this.axe.isEmpty()) {
                return true;
            }
            int minY = this.hits.keySet().intStream().min().getAsInt();
            Queue queue = (Queue)this.hits.get(minY);
            int breaks = 0;
            while (!queue.isEmpty()) {
                BlockPos pos = (BlockPos)queue.poll();
                for (BlockPos p : BlockPos.betweenClosed((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1))) {
                    BlockState state;
                    if (p.equals((Object)pos) || !(state = this.level.getBlockState(p)).is(BlockTags.LOGS)) continue;
                    MiscUtil.breakExtraBlock(this.level, p, this.axe, this.owner);
                    if (this.level.getBlockState(p).is(BlockTags.LOGS)) continue;
                    ((Queue)this.hits.computeIfAbsent(p.getY(), i -> new ArrayDeque())).add(p.immutable());
                    ++breaks;
                }
                if (breaks <= 5) continue;
                break;
            }
            if (queue.isEmpty()) {
                this.hits.remove(minY);
            }
            return this.hits.isEmpty();
        }
    }
}

