/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.masterwork;

import dev.shadowsoffire.apothic_enchanting.Ench;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class CrescendoEnchant
extends Enchantment {
    private static ThreadLocal<ListTag> nbt = new ThreadLocal();

    public CrescendoEnchant() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.CROSSBOW, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int getMaxLevel() {
        return 5;
    }

    public int getMinCost(int level) {
        return 55 + (level - 1) * 30;
    }

    public int getMaxCost(int level) {
        return 200;
    }

    public Component getFullname(int level) {
        return ((MutableComponent)super.getFullname(level)).withStyle(ChatFormatting.DARK_GREEN);
    }

    public static void preArrowFired(ItemStack crossbow) {
        int level = crossbow.getEnchantmentLevel((Enchantment)Ench.Enchantments.CRESCENDO.get());
        if (level > 0) {
            nbt.set(crossbow.getTag().getList("ChargedProjectiles", 10).copy());
        }
    }

    public static void onArrowFired(ItemStack crossbow) {
        int level = crossbow.getEnchantmentLevel((Enchantment)Ench.Enchantments.CRESCENDO.get());
        if (level > 0 && nbt.get() != null) {
            int shots = crossbow.getTag().getInt("shots");
            if (shots < level) {
                crossbow.getTag().putInt("shots", shots + 1);
                CrossbowItem.setCharged((ItemStack)crossbow, (boolean)true);
                crossbow.getTag().put("ChargedProjectiles", (Tag)nbt.get());
            } else {
                crossbow.getTag().remove("shots");
            }
            nbt.set(null);
        }
    }

    public static void markGeneratedArrows(Projectile arrow, ItemStack crossbow) {
        if (crossbow.getTag().getInt("shots") > 0 && arrow instanceof AbstractArrow) {
            AbstractArrow arr = (AbstractArrow)arrow;
            arr.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }
}

