/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.masterwork;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;

public class EndlessQuiverEnchant
extends Enchantment {
    public EndlessQuiverEnchant() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.BOW, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMinCost(int enchantmentLevel) {
        return 60;
    }

    public int getMaxCost(int enchantmentLevel) {
        return 200;
    }

    public Component getFullname(int level) {
        return ((MutableComponent)super.getFullname(level)).withStyle(ChatFormatting.DARK_GREEN);
    }

    protected boolean checkCompatibility(Enchantment ench) {
        return super.checkCompatibility(ench) && ench != Enchantments.INFINITY_ARROWS;
    }

    public boolean isTrulyInfinite(ItemStack stack, ItemStack bow, Player player) {
        return bow.getEnchantmentLevel((Enchantment)this) > 0 && stack.getItem() instanceof ArrowItem;
    }
}

