/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.masterwork;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class ScavengerEnchant
extends Enchantment {
    private static final MethodHandle dropFromLootTable;

    public ScavengerEnchant() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int getMinCost(int level) {
        return 55 + level * level * 12;
    }

    public int getMaxCost(int level) {
        return 200;
    }

    public int getMaxLevel() {
        return 3;
    }

    public Component getFullname(int level) {
        return ((MutableComponent)super.getFullname(level)).withStyle(ChatFormatting.DARK_GREEN);
    }

    public void drops(Player p, LivingDropsEvent e) throws Throwable {
        if (p.level().isClientSide) {
            return;
        }
        int scavenger = p.getMainHandItem().getEnchantmentLevel((Enchantment)this);
        if (scavenger > 0 && (float)p.level().random.nextInt(100) < (float)scavenger * 2.5f) {
            e.getEntity().captureDrops(new ArrayList());
            dropFromLootTable.invoke(e.getEntity(), e.getSource(), true);
            e.getDrops().addAll(e.getEntity().captureDrops(null));
        }
    }

    static {
        Method m = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"dropFromLootTable", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
        try {
            m.setAccessible(true);
            dropFromLootTable = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("LivingEntity#dropFromLootTable not located!");
        }
    }
}

