/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.twisted;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DiggingEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class MinersFervorEnchant
extends DiggingEnchantment {
    public MinersFervorEnchant() {
        super(Enchantment.Rarity.RARE, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int getMinCost(int enchantmentLevel) {
        return 45 + (enchantmentLevel - 1) * 30;
    }

    public int getMaxCost(int enchantmentLevel) {
        return this.getMinCost(enchantmentLevel) + 50;
    }

    public int getMaxLevel() {
        return 5;
    }

    public Component getFullname(int level) {
        return ((MutableComponent)super.getFullname(level)).withStyle(ChatFormatting.DARK_PURPLE);
    }

    protected boolean checkCompatibility(Enchantment e) {
        return super.checkCompatibility(e) && e != Enchantments.BLOCK_EFFICIENCY;
    }

    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        Player p = e.getEntity();
        ItemStack stack = p.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        int level = stack.getEnchantmentLevel((Enchantment)this);
        if (level > 0 && stack.getDestroySpeed(e.getState()) > 1.0f) {
            float hardness = e.getState().getDestroySpeed((BlockGetter)p.level(), e.getPosition().orElse(BlockPos.ZERO));
            e.setNewSpeed(Math.min(29.9999f, 7.5f + 4.5f * (float)level) * hardness);
        }
    }
}

