/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.library;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryTile;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.packets.ButtonClickMessage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class EnchLibraryContainer
extends BlockEntityMenu<EnchLibraryTile>
implements ButtonClickMessage.IButtonContainer {
    protected SimpleContainer ioInv = new SimpleContainer(3);
    protected Runnable notifier = null;

    public EnchLibraryContainer(int id, Inventory inv, BlockPos pos) {
        super(Ench.Menus.LIBRARY.get(), id, inv, pos);
        ((EnchLibraryTile)this.tile).addListener(this);
        this.initCommon(inv);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!this.level.isClientSide) {
            ((EnchLibraryTile)this.tile).removeListener(this);
        }
        this.clearContainer(player, (Container)this.ioInv);
    }

    void initCommon(final Inventory inv) {
        this.addSlot(new Slot((Container)this.ioInv, 0, 142, 77){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == Items.ENCHANTED_BOOK;
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void setChanged() {
                super.setChanged();
                if (!((EnchLibraryContainer)EnchLibraryContainer.this).level.isClientSide && !this.getItem().isEmpty()) {
                    ((EnchLibraryTile)EnchLibraryContainer.this.tile).depositBook(this.getItem());
                }
                if (!this.getItem().isEmpty() && ((EnchLibraryContainer)EnchLibraryContainer.this).level.isClientSide) {
                    inv.player.level().playSound(inv.player, EnchLibraryContainer.this.pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 0.5f, 0.7f);
                }
                EnchLibraryContainer.this.ioInv.setItem(0, ItemStack.EMPTY);
            }
        });
        this.addSlot(new Slot((Container)this.ioInv, 1, 142, 106){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == Items.ENCHANTED_BOOK;
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot((Container)this.ioInv, 2, 142, 18){

            public boolean mayPlace(ItemStack stack) {
                return true;
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void setChanged() {
                EnchLibraryContainer.this.onChanged();
            }
        });
        this.addPlayerSlots(inv, 8, 148);
        this.mover.registerRule((stack, slot) -> slot == 0, 3, 39);
        this.mover.registerRule((stack, slot) -> slot == 1, 3, 39);
        this.mover.registerRule((stack, slot) -> slot == 2, 3, 39);
        this.mover.registerRule((stack, slot) -> stack.is(Items.ENCHANTED_BOOK), 0, 1);
        this.mover.registerRule((stack, slot) -> true, 2, 3);
        this.registerInvShuffleRules();
    }

    public boolean stillValid(Player player) {
        return player.distanceToSqr((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ()) < 256.0 && this.tile != null && !((EnchLibraryTile)this.tile).isRemoved();
    }

    public int getNumStoredEnchants() {
        return (int)((EnchLibraryTile)this.tile).getPointsMap().values().intStream().filter(s -> s > 0).count();
    }

    public List<Object2IntMap.Entry<Enchantment>> getPointsForDisplay() {
        return ((EnchLibraryTile)this.tile).getPointsMap().object2IntEntrySet().stream().filter(s -> s.getIntValue() > 0).toList();
    }

    public int getMaxLevel(Enchantment enchant) {
        return ((EnchLibraryTile)this.tile).getMax(enchant);
    }

    public int getPointCap() {
        return ((EnchLibraryTile)this.tile).maxPoints;
    }

    public void setNotifier(Runnable r) {
        this.notifier = r;
    }

    public void onChanged() {
        if (this.notifier != null) {
            this.notifier.run();
        }
    }

    public void onButtonClick(int id) {
        int targetLevel;
        boolean shift;
        boolean bl = shift = (id & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (shift) {
            id &= Integer.MAX_VALUE;
        }
        Enchantment ench = (Enchantment)BuiltInRegistries.ENCHANTMENT.byId(id);
        ItemStack outSlot = this.ioInv.getItem(1);
        int curLvl = EnchantmentHelper.getEnchantments((ItemStack)outSlot).getOrDefault(ench, 0);
        int n = targetLevel = shift ? Math.min(((EnchLibraryTile)this.tile).getMax(ench), 1 + (int)(Math.log(((EnchLibraryTile)this.tile).getPointsMap().getInt((Object)ench) + EnchLibraryTile.levelToPoints(curLvl)) / Math.log(2.0))) : curLvl + 1;
        if (!((EnchLibraryTile)this.tile).canExtract(ench, targetLevel, curLvl)) {
            return;
        }
        if (outSlot.isEmpty()) {
            outSlot = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        ((EnchLibraryTile)this.tile).extractEnchant(outSlot, ench, targetLevel);
        this.ioInv.setItem(1, outSlot);
    }
}

