/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.mixin;

import dev.shadowsoffire.apothic_enchanting.asm.EnchHooks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemStack.class}, priority=500, remap=false)
public class ItemStackMixin {
    private static void appendModifiedEnchTooltip(List<Component> tooltip, Enchantment ench, int realLevel, int nbtLevel) {
        int diff;
        MutableComponent mc = ench.getFullname(realLevel).copy();
        mc.getSiblings().clear();
        MutableComponent nbtLevelComp = Component.translatable((String)("enchantment.level." + nbtLevel));
        MutableComponent realLevelComp = Component.translatable((String)("enchantment.level." + realLevel));
        if (realLevel != 1 || EnchHooks.getMaxLevel(ench) != 1) {
            mc.append(CommonComponents.SPACE).append((Component)realLevelComp);
        }
        char sign = (diff = realLevel - nbtLevel) > 0 ? (char)'+' : '-';
        MutableComponent diffComp = Component.translatable((String)("(%s " + sign + " %s)"), (Object[])new Object[]{nbtLevelComp, Component.translatable((String)("enchantment.level." + Math.abs(diff)))}).withStyle(ChatFormatting.DARK_GRAY);
        mc.append(CommonComponents.SPACE).append((Component)diffComp);
        if (realLevel == 0) {
            mc.withStyle(ChatFormatting.DARK_GRAY);
        }
        tooltip.add((Component)mc);
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;appendEnchantmentNames(Ljava/util/List;Lnet/minecraft/nbt/ListTag;)V"))
    public void apoth_enchTooltipRewrite(List<Component> tooltip, ListTag tagEnchants) {
        ItemStack ths = (ItemStack)this;
        HashMap realLevels = new HashMap(ths.getAllEnchantments());
        ArrayList<Component> enchTooltips = new ArrayList<Component>();
        for (int i = tagEnchants.size() - 1; i >= 0; --i) {
            int realLevel;
            CompoundTag compoundtag = tagEnchants.getCompound(i);
            Enchantment ench = (Enchantment)BuiltInRegistries.ENCHANTMENT.get(EnchantmentHelper.getEnchantmentId((CompoundTag)compoundtag));
            if (ench == null || !realLevels.containsKey(ench)) continue;
            int nbtLevel = EnchantmentHelper.getEnchantmentLevel((CompoundTag)compoundtag);
            if (nbtLevel == (realLevel = ((Integer)realLevels.remove(ench)).intValue())) {
                enchTooltips.add(ench.getFullname(EnchantmentHelper.getEnchantmentLevel((CompoundTag)compoundtag)));
                continue;
            }
            ItemStackMixin.appendModifiedEnchTooltip(enchTooltips, ench, realLevel, nbtLevel);
        }
        Collections.reverse(enchTooltips);
        tooltip.addAll(enchTooltips);
        for (Map.Entry real : realLevels.entrySet()) {
            if ((Integer)real.getValue() <= 0) continue;
            ItemStackMixin.appendModifiedEnchTooltip(tooltip, (Enchantment)real.getKey(), (Integer)real.getValue(), 0);
        }
    }
}

