/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;

public class ExtractionTomeItem
extends BookItem {
    public ExtractionTomeItem() {
        super(new Item.Properties());
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.isEnchanted()) {
            return;
        }
        tooltip.add((Component)TooltipUtil.lang("info", "extraction_tome", new Object[0]).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TooltipUtil.lang("info", "extraction_tome2", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public Rarity getRarity(ItemStack stack) {
        return Rarity.EPIC;
    }

    public boolean isFoil(ItemStack pStack) {
        return true;
    }

    public static boolean updateAnvil(AnvilUpdateEvent ev) {
        ItemStack weapon = ev.getLeft();
        ItemStack book = ev.getRight();
        if (!(book.getItem() instanceof ExtractionTomeItem) || book.isEnchanted() || !weapon.isEnchanted()) {
            return false;
        }
        Map wepEnch = EnchantmentHelper.getEnchantments((ItemStack)weapon);
        ItemStack out = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentHelper.setEnchantments((Map)wepEnch, (ItemStack)out);
        ev.setMaterialCost(1);
        ev.setCost(wepEnch.size() * 16);
        ev.setOutput(out);
        return true;
    }

    protected static void giveItem(Player player, ItemStack stack) {
        if (!player.isAlive() || player instanceof ServerPlayer && ((ServerPlayer)player).hasDisconnected()) {
            player.drop(stack, false);
        } else {
            Inventory inventory = player.getInventory();
            if (inventory.player instanceof ServerPlayer) {
                inventory.placeItemBackInInventory(stack);
            }
        }
    }

    public static boolean updateRepair(AnvilRepairEvent ev) {
        ItemStack weapon = ev.getLeft();
        ItemStack book = ev.getRight();
        if (!(book.getItem() instanceof ExtractionTomeItem) || book.isEnchanted() || !weapon.isEnchanted()) {
            return false;
        }
        EnchantmentHelper.setEnchantments(Collections.emptyMap(), (ItemStack)weapon);
        ExtractionTomeItem.giveItem(ev.getEntity(), weapon);
        return true;
    }
}

