/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import dev.shadowsoffire.placebo.network.VanillaPacketDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;

public class FilteringShelfBlock
extends ChiseledBookShelfBlock
implements EnchantmentStatBlock {
    public FilteringShelfBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public Set<Enchantment> getBlacklistedEnchantments(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            HashSet<Enchantment> blacklist = new HashSet<Enchantment>();
            for (ItemStack s : shelf.getBooks()) {
                Enchantment ench;
                Map enchants = EnchantmentHelper.getEnchantments((ItemStack)s);
                if (enchants.size() != 1 || (ench = (Enchantment)enchants.keySet().stream().findFirst().orElse(null)) == null) continue;
                blacklist.add(ench);
            }
            return blacklist;
        }
        return Collections.emptySet();
    }

    @Override
    public float getMaxEnchantingPower(BlockState state, LevelReader world, BlockPos pos) {
        return 30.0f;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            return (float)shelf.getBooks().size() * 0.5f;
        }
        return 0.0f;
    }

    @Override
    public float getArcanaBonus(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            return shelf.getBooks().size();
        }
        return 0.0f;
    }

    @Override
    public ParticleOptions getTableParticle(BlockState state) {
        return (ParticleOptions)Ench.Particles.ENCHANT_WATER.get();
    }

    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity shelf = (ChiseledBookShelfBlockEntity)be;
            Optional hitResult = FilteringShelfBlock.getRelativeHitCoordinatesForBlockFace((BlockHitResult)pHit, (Direction)((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
            if (hitResult.isEmpty()) {
                return InteractionResult.PASS;
            }
            int slot = FilteringShelfBlock.getHitSlot((Vec2)((Vec2)hitResult.get()));
            if (((Boolean)pState.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(slot))).booleanValue()) {
                FilteringShelfBlock.removeBook((Level)pLevel, (BlockPos)pPos, (Player)pPlayer, (ChiseledBookShelfBlockEntity)shelf, (int)slot);
                return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            }
            ItemStack stack = pPlayer.getItemInHand(pHand);
            if (FilteringShelfBlock.canInsert(stack)) {
                FilteringShelfBlock.addBook((Level)pLevel, (BlockPos)pPos, (Player)pPlayer, (ChiseledBookShelfBlockEntity)shelf, (ItemStack)stack, (int)slot);
                return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FilteringShelfTile(pPos, pState);
    }

    public void appendHoverText(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)TooltipUtil.lang("info", "filtering_shelf", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public static boolean canInsert(ItemStack stack) {
        return stack.is(Items.ENCHANTED_BOOK) && EnchantedBookItem.getEnchantments((ItemStack)stack).size() == 1;
    }

    public static class FilteringShelfTile
    extends ChiseledBookShelfBlockEntity {
        public FilteringShelfTile(BlockPos pPos, BlockState pState) {
            super(pPos, pState);
        }

        public boolean canPlaceItem(int pIndex, ItemStack pStack) {
            return FilteringShelfBlock.canInsert(pStack);
        }

        public BlockEntityType<?> getType() {
            return Ench.Tiles.FILTERING_SHELF.get();
        }

        public List<ItemStack> getBooks() {
            ArrayList<ItemStack> books = new ArrayList<ItemStack>();
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) continue;
                books.add(stack);
            }
            return books;
        }

        public CompoundTag getUpdateTag() {
            CompoundTag tag = new CompoundTag();
            this.saveAdditional(tag);
            return tag;
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            this.load(pkt.getTag());
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public void setItem(int pSlot, ItemStack pStack) {
            super.setItem(pSlot, pStack);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
    }
}

