/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import com.google.common.collect.Lists;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.AnvilUpdateEvent;

public class ScrappingTomeItem
extends BookItem {
    static Random rand = new Random();

    public ScrappingTomeItem() {
        super(new Item.Properties());
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.isEnchanted()) {
            return;
        }
        tooltip.add((Component)TooltipUtil.lang("info", "scrap_tome", new Object[0]).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TooltipUtil.lang("info", "scrap_tome2", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public Rarity getRarity(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public static boolean updateAnvil(AnvilUpdateEvent ev) {
        ItemStack weapon = ev.getLeft();
        ItemStack book = ev.getRight();
        if (!(book.getItem() instanceof ScrappingTomeItem) || book.isEnchanted() || !weapon.isEnchanted()) {
            return false;
        }
        Map wepEnch = EnchantmentHelper.getEnchantments((ItemStack)weapon);
        int size = Mth.ceil((double)((double)wepEnch.size() / 2.0));
        ArrayList keys = Lists.newArrayList(wepEnch.keySet());
        long seed = 1831L;
        for (Enchantment e : keys) {
            seed ^= (long)BuiltInRegistries.ENCHANTMENT.getKey((Object)e).hashCode();
        }
        rand.setSeed(seed ^= (long)ev.getPlayer().getEnchantmentSeed());
        while (wepEnch.size() > size) {
            Enchantment lost = (Enchantment)keys.get(rand.nextInt(keys.size()));
            wepEnch.remove(lost);
            keys.remove(lost);
        }
        ItemStack out = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentHelper.setEnchantments((Map)wepEnch, (ItemStack)out);
        ev.setMaterialCost(1);
        ev.setCost(wepEnch.size() * 6);
        ev.setOutput(out);
        return true;
    }
}

