/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.api.EnchantableItem;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TomeItem
extends BookItem
implements EnchantableItem {
    final ItemStack rep;
    final EnchantmentCategory type;

    public TomeItem(Item rep, EnchantmentCategory type) {
        super(new Item.Properties());
        this.type = type;
        this.rep = new ItemStack((ItemLike)rep);
        ApothicEnchanting.TYPED_BOOKS.add(this);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return stack.getCount() == 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.type == null) {
            return ApothicEnchanting.TYPED_BOOKS.stream().filter(b -> b != this).allMatch(b -> !enchantment.canEnchant(new ItemStack((ItemLike)b)));
        }
        return enchantment.canApplyAtEnchantingTable(this.rep);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)TooltipUtil.lang("info", BuiltInRegistries.ITEM.getKey((Object)this).getPath(), new Object[0]).withStyle(ChatFormatting.GRAY));
        if (stack.isEnchanted()) {
            tooltip.add((Component)TooltipUtil.lang("info", "tome_error", new Object[0]).withStyle(ChatFormatting.RED));
        }
    }

    public Rarity getRarity(ItemStack stack) {
        return !stack.isEnchanted() ? super.getRarity(stack) : Rarity.UNCOMMON;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEnchanted()) {
            ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, stack.getCount());
            EnchantmentHelper.setEnchantments((Map)EnchantmentHelper.getEnchantments((ItemStack)stack), (ItemStack)book);
            return InteractionResultHolder.consume((Object)book);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public ItemStack applyEnchantments(ItemStack stack, List<EnchantmentInstance> enchantments) {
        stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        for (EnchantmentInstance inst : enchantments) {
            EnchantedBookItem.addEnchantment((ItemStack)stack, (EnchantmentInstance)inst);
        }
        return stack;
    }

    @Override
    public boolean forciblyAllowsTableEnchantment(ItemStack stack, Enchantment enchantment) {
        return this.canApplyAtEnchantingTable(stack, enchantment);
    }
}

