/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.payloads;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentScreen;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class CluePayload
implements CustomPacketPayload {
    public static final ResourceLocation ID = ApothicEnchanting.loc("clue");
    protected final int slot;
    protected final List<EnchantmentInstance> clues;
    protected final boolean all;

    public CluePayload(int slot, List<EnchantmentInstance> clues, boolean all) {
        this.slot = slot;
        this.clues = clues;
        this.all = all;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.clues.size());
        for (EnchantmentInstance e : this.clues) {
            buf.writeShort(BuiltInRegistries.ENCHANTMENT.getId((Object)e.enchantment));
            buf.writeByte(e.level);
        }
        buf.writeByte(this.slot);
        buf.writeBoolean(this.all);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static class Provider
    implements PayloadProvider<CluePayload, PlayPayloadContext> {
        public ResourceLocation id() {
            return ID;
        }

        public CluePayload read(FriendlyByteBuf buf) {
            int size = buf.readByte();
            ArrayList<EnchantmentInstance> clues = new ArrayList<EnchantmentInstance>(size);
            for (int i = 0; i < size; ++i) {
                Enchantment ench = (Enchantment)BuiltInRegistries.ENCHANTMENT.byIdOrThrow((int)buf.readShort());
                clues.add(new EnchantmentInstance(ench, (int)buf.readByte()));
            }
            return new CluePayload(buf.readByte(), clues, buf.readBoolean());
        }

        public void handle(CluePayload msg, PlayPayloadContext ctx) {
            PayloadHelper.handle(() -> {
                Screen patt2840$temp = Minecraft.getInstance().screen;
                if (patt2840$temp instanceof ApothEnchantmentScreen) {
                    ApothEnchantmentScreen es = (ApothEnchantmentScreen)patt2840$temp;
                    es.acceptClues(msg.slot, msg.clues, msg.all);
                }
            }, (IPayloadContext)ctx);
        }

        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.CLIENTBOUND);
        }
    }
}

