/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.replacements;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class BaneEnchant
extends DamageEnchantment {
    protected final MobType attrib;

    public BaneEnchant(Enchantment.Rarity rarity, MobType attrib, EquipmentSlot ... slots) {
        super(rarity, 0, slots);
        this.attrib = attrib;
    }

    public int getMinCost(int level) {
        if (this.attrib == MobType.UNDEFINED) {
            return 1 + (level - 1) * 11;
        }
        return 5 + (level - 1) * 8;
    }

    public int getMaxCost(int level) {
        return this.getMinCost(level) + 20;
    }

    public int getMaxLevel() {
        return 5;
    }

    public float getDamageBonus(int level, MobType attrib) {
        if (this.attrib == MobType.UNDEFINED) {
            return 1.0f + (float)level * 0.5f;
        }
        if (this.attrib == attrib) {
            return (float)level * 1.5f;
        }
        return 0.0f;
    }

    public boolean checkCompatibility(Enchantment ench) {
        if (this.attrib == MobType.UNDEFINED) {
            return ench != this;
        }
        return ench == Enchantments.SHARPNESS ? ench != this : !(ench instanceof BaneEnchant);
    }

    public void doPostAttack(LivingEntity user, Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            if (this.attrib != MobType.UNDEFINED && livingentity.getMobType() == this.attrib) {
                int i = 20 + user.getRandom().nextInt(10 * level);
                livingentity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, i, 3));
            }
        }
    }
}

