/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.replacements;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;

public class DefenseEnchant
extends ProtectionEnchantment {
    public DefenseEnchant(Enchantment.Rarity rarity, ProtectionEnchantment.Type type, EquipmentSlot ... slots) {
        super(rarity, type, slots);
    }

    public int getDamageProtection(int level, DamageSource source) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return 0;
        }
        if (this.type == ProtectionEnchantment.Type.ALL) {
            return level;
        }
        if (this.type == ProtectionEnchantment.Type.FIRE && source.is(DamageTypeTags.IS_FIRE)) {
            return level;
        }
        if (this.type == ProtectionEnchantment.Type.FALL && source.is(DamageTypeTags.IS_FALL)) {
            return level * 3;
        }
        if (this.type == ProtectionEnchantment.Type.EXPLOSION && source.is(DamageTypeTags.IS_EXPLOSION)) {
            return level * 2;
        }
        return this.type == ProtectionEnchantment.Type.PROJECTILE && source.is(DamageTypeTags.IS_PROJECTILE) ? level : 0;
    }

    public boolean checkCompatibility(Enchantment ench) {
        if (this == Enchantments.FALL_PROTECTION || this == Enchantments.ALL_DAMAGE_PROTECTION) {
            return ench != this;
        }
        if (ench instanceof ProtectionEnchantment) {
            ProtectionEnchantment pEnch = (ProtectionEnchantment)ench;
            if (ench == this) {
                return false;
            }
            return pEnch.type == ProtectionEnchantment.Type.ALL || pEnch.type == ProtectionEnchantment.Type.FALL;
        }
        return ench != this;
    }
}

