/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.EnchantmentInfo;
import dev.shadowsoffire.apothic_enchanting.api.EnchantableItem;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableStats;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class ApothEnchantmentHelper {
    public static int getEnchantmentCost(RandomSource rand, int num, float eterna, ItemStack stack) {
        int level = Math.round(eterna);
        if (num == 2) {
            return level;
        }
        float lowBound = 0.6f - 0.4f * (float)(1 - num);
        float highBound = 0.8f - 0.4f * (float)(1 - num);
        return Math.max(1, Math.round((float)level * Mth.nextFloat((RandomSource)rand, (float)lowBound, (float)highBound)));
    }

    public static List<EnchantmentInstance> selectEnchantment(RandomSource rand, ItemStack stack, int level, EnchantmentTableStats stats) {
        ArrayList<EnchantmentInstance> chosenEnchants = new ArrayList<EnchantmentInstance>();
        int enchantability = stack.getEnchantmentValue();
        if (enchantability > 0) {
            float quantaFactor = ApothEnchantmentHelper.getQuantaFactor(rand, stats.quanta(), stats.stable());
            int power = Mth.clamp((int)Math.round((float)level * quantaFactor), (int)1, (int)200);
            ApothEnchantmentMenu.Arcana arcanaVals = ApothEnchantmentMenu.Arcana.getForThreshold(stats.arcana());
            List<EnchantmentInstance> allEnchants = ApothEnchantmentHelper.getAvailableEnchantmentResults(power, stack, stats.treasure(), stats.blacklist());
            Map enchants = EnchantmentHelper.getEnchantments((ItemStack)stack);
            allEnchants.removeIf(e -> enchants.containsKey(e.enchantment));
            List<ArcanaEnchantmentData> possibleEnchants = allEnchants.stream().map(d -> new ArcanaEnchantmentData(arcanaVals, (EnchantmentInstance)d)).collect(Collectors.toList());
            for (int i = 0; i < 100; i += 33) {
                if (!(stats.arcana() >= (float)i) || possibleEnchants.size() <= 0) continue;
                ApothEnchantmentHelper.pickEnchantment(rand, chosenEnchants, possibleEnchants);
            }
            int randomBound = Math.max(50, (int)((float)level * 1.25f));
            while (rand.nextInt(randomBound) <= level && possibleEnchants.size() > 0) {
                ApothEnchantmentHelper.pickEnchantment(rand, chosenEnchants, possibleEnchants);
                level /= 2;
            }
        }
        return ((EnchantableItem)stack.getItem()).selectEnchantments(chosenEnchants, rand, stack, level, stats);
    }

    public static void pickEnchantment(RandomSource rand, List<EnchantmentInstance> chosenEnchants, List<ArcanaEnchantmentData> possibleEnchants) {
        chosenEnchants.add(((ArcanaEnchantmentData)((Object)WeightedRandom.getRandomItem((RandomSource)rand, possibleEnchants).get())).data);
        ApothEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentInstance)Util.lastOf(chosenEnchants));
    }

    public static void removeIncompatible(List<ArcanaEnchantmentData> possibleEnchants, EnchantmentInstance data) {
        Iterator<ArcanaEnchantmentData> iterator = possibleEnchants.iterator();
        while (iterator.hasNext()) {
            if (data.enchantment.isCompatibleWith(iterator.next().data.enchantment)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int power, ItemStack stack, boolean allowTreasure, Set<Enchantment> blacklist) {
        ArrayList<EnchantmentInstance> list = new ArrayList<EnchantmentInstance>();
        EnchantableItem item = (EnchantableItem)stack.getItem();
        allowTreasure = item.isTreasureAllowed(stack, allowTreasure);
        block0: for (Enchantment enchantment : BuiltInRegistries.ENCHANTMENT) {
            EnchantmentInfo info = ApothicEnchanting.getEnchInfo(enchantment);
            if (info.isTreasure() && !allowTreasure || !info.isDiscoverable() || blacklist.contains(enchantment) || !enchantment.canApplyAtEnchantingTable(stack) && !item.forciblyAllowsTableEnchantment(stack, enchantment)) continue;
            for (int level = info.getMaxLevel(); level > enchantment.getMinLevel() - 1; --level) {
                if (power < info.getMinPower(level) || power > info.getMaxPower(level)) continue;
                list.add(new EnchantmentInstance(enchantment, level));
                continue block0;
            }
        }
        return list;
    }

    public static float getQuantaFactor(RandomSource rand, float quanta, boolean isStable) {
        if (isStable) {
            return 1.0f + quanta * rand.nextFloat();
        }
        float gaussian = (float)rand.nextGaussian();
        float factor = Mth.clamp((float)(gaussian / 3.0f), (float)-1.0f, (float)1.0f);
        return 1.0f + quanta * factor / 100.0f;
    }

    public static class ArcanaEnchantmentData
    extends WeightedEntry.IntrusiveBase {
        EnchantmentInstance data;

        public ArcanaEnchantmentData(ApothEnchantmentMenu.Arcana arcana, EnchantmentInstance data) {
            super(arcana.getRarities()[data.enchantment.getRarity().ordinal()]);
            this.data = data;
        }
    }
}

