/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableItemHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class ApothEnchantmentTableBlock
extends EnchantmentTableBlock {
    public ApothEnchantmentTableBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof EnchantmentTableBlockEntity) {
            Component itextcomponent = ((Nameable)tileentity).getDisplayName();
            return new SimpleMenuProvider((id, inventory, player) -> new ApothEnchantmentMenu(id, inventory, ContainerLevelAccess.create((Level)world, (BlockPos)pos), (EnchantmentTableItemHandler)((Object)((Object)tileentity.getData(EnchantmentTableItemHandler.TYPE)))), itextcomponent);
        }
        return null;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (state.getBlock() != newState.getBlock() && (tileentity = world.getBlockEntity(pos)) instanceof EnchantmentTableBlockEntity) {
            ItemStack fuel = ((EnchantmentTableItemHandler)((Object)tileentity.getData(EnchantmentTableItemHandler.TYPE))).getStackInSlot(0);
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)fuel);
            world.removeBlockEntity(pos);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        for (BlockPos offset : BOOKSHELF_OFFSETS) {
            BlockState shelfState = level.getBlockState(pos.offset((Vec3i)offset));
            ((EnchantmentStatBlock)shelfState.getBlock()).spawnTableParticle(shelfState, level, rand, pos, offset);
        }
    }

    public static IItemHandler getItemHandler(EnchantmentTableBlockEntity be, Direction dir) {
        return (IItemHandler)be.getData(EnchantmentTableItemHandler.TYPE);
    }
}

