/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentHelper;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentScreen;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class EnchantingInfoScreen
extends Screen {
    public static final ResourceLocation TEXTURES = ApothicEnchanting.loc("textures/gui/enchanting_info.png");
    protected static ChatFormatting[] colors = new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.YELLOW, ChatFormatting.BLUE, ChatFormatting.GOLD};
    protected final ApothEnchantmentScreen parent;
    protected final int imageWidth;
    protected final int imageHeight;
    protected final ItemStack toEnchant;
    protected final int[] costs;
    protected final int[] clues;
    protected final int[][] powers = new int[3][];
    protected final boolean treasure;
    protected int selectedSlot = -1;
    protected int leftPos;
    protected int topPos;
    protected PowerSlider slider;
    protected int currentPower;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    List<EnchantmentDataWrapper> enchantments = Collections.emptyList();
    Map<Enchantment, List<Enchantment>> exclusions = new HashMap<Enchantment, List<Enchantment>>();

    public EnchantingInfoScreen(ApothEnchantmentScreen parent) {
        super((Component)TooltipUtil.lang("menu", "enchanting_info", new Object[0]));
        this.parent = parent;
        this.imageWidth = 240;
        this.imageHeight = 170;
        this.toEnchant = parent.getMenu().getSlot(0).getItem();
        this.costs = parent.getMenu().costs;
        this.clues = parent.getMenu().enchantClue;
        this.treasure = parent.getMenu().stats.treasure();
        for (int i = 0; i < 3; ++i) {
            Enchantment clue = Enchantment.byId((int)this.clues[i]);
            if (clue == null) continue;
            int level = this.costs[i];
            float quanta = parent.getMenu().stats.quanta() / 100.0f;
            int minPow = parent.getMenu().stats.stable() ? level : Math.round(Mth.clamp((float)((float)level - (float)level * quanta), (float)1.0f, (float)200.0f));
            int maxPow = Math.round(Mth.clamp((float)((float)level + (float)level * quanta), (float)1.0f, (float)200.0f));
            this.powers[i] = new int[]{minPow, maxPow};
            this.selectedSlot = i;
        }
    }

    protected void init() {
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.slider = (PowerSlider)this.addRenderableWidget((GuiEventListener)new PowerSlider(this.leftPos + 5, this.topPos + 80, 80, 20));
    }

    public void render(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTick) {
        int i;
        int v;
        PoseStack pose = gfx.pose();
        pose.pushPose();
        pose.translate((float)this.leftPos, (float)this.topPos, 0.0f);
        gfx.blit(TEXTURES, 0, 0, 0, 0, this.imageWidth, this.imageHeight);
        for (int i2 = 0; i2 < 3; ++i2) {
            Enchantment clue = Enchantment.byId((int)this.clues[i2]);
            int u = 199;
            v = 225;
            if (clue == null) {
                u += 19;
                v += 16;
            } else if (this.selectedSlot == i2 || this.isHovering(8, 18 + 18 * i2, 18, 16, pMouseX, pMouseY)) {
                u += 38;
            }
            gfx.blit(TEXTURES, 8, 18 + 19 * i2, 224, u, 18, 19);
            gfx.blit(TEXTURES, 9, 22 + 18 * i2 + i2, 16 * i2, v, 16, 16);
        }
        int scrollbarPos = (int)(128.0f * this.scrollOffs);
        gfx.blit(TEXTURES, 220, 18 + scrollbarPos, 244, 173 + (this.isScrollBarActive() ? 0 : 15), 12, 15);
        EnchantmentDataWrapper hover = this.getHovered(pMouseX, pMouseY);
        for (i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            v = 173;
            EnchantmentDataWrapper data = this.enchantments.get(this.startIndex + i);
            if (data.isBlacklisted) {
                v += 26;
            } else if (hover == this.enchantments.get(this.startIndex + i)) {
                v += 13;
            }
            gfx.blit(TEXTURES, 89, 18 + 13 * i, 96, v, 128, 13);
        }
        for (i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            EnchantmentDataWrapper data = this.enchantments.get(this.startIndex + i);
            if (data.isBlacklisted) {
                gfx.drawString(this.font, (Component)Component.translatable((String)data.getEnch().getDescriptionId()).withStyle(s -> s.withColor(5812428).withStrikethrough(Boolean.valueOf(true))), 91, 21 + 13 * i, 0xFFFF80, false);
                continue;
            }
            gfx.drawString(this.font, I18n.get((String)data.getEnch().getDescriptionId(), (Object[])new Object[0]), 91, 21 + 13 * i, 0xFFFF80, false);
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        ApothEnchantmentMenu.Arcana a = ApothEnchantmentMenu.Arcana.getForThreshold(this.parent.getMenu().stats.arcana());
        list.add(TooltipUtil.lang("info", "weights", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.YELLOW}));
        list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.common", (Object[])new Object[0]), a.rarities[0]).withStyle(ChatFormatting.GRAY));
        list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.uncommon", (Object[])new Object[0]), a.rarities[1]).withStyle(ChatFormatting.GREEN));
        list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.rare", (Object[])new Object[0]), a.rarities[2]).withStyle(ChatFormatting.BLUE));
        list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.very_rare", (Object[])new Object[0]), a.rarities[3]).withStyle(ChatFormatting.GOLD));
        gfx.renderComponentTooltip(this.font, list, a == ApothEnchantmentMenu.Arcana.MAX ? -2 : 1, 120);
        gfx.drawString(this.font, this.title, 7, 4, 0x404040, false);
        pose.popPose();
        pose.translate(0.0f, 0.0f, 10.0f);
        for (int i3 = 0; i3 < 3; ++i3) {
            if (!this.isHovering(8, 18 + 18 * i3, 18, 16, pMouseX, pMouseY)) continue;
            list.clear();
            list.add(TooltipUtil.lang("info", "enchinfo_slot", i3 + 1).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}));
            list.add(TooltipUtil.lang("info", "enchinfo_level", this.costs[i3]).withStyle(ChatFormatting.GREEN));
            list.add(TooltipUtil.lang("info", "enchinfo_minpow", this.powers[i3][0]).withStyle(ChatFormatting.RED));
            list.add(TooltipUtil.lang("info", "enchinfo_maxpow", this.powers[i3][1]).withStyle(ChatFormatting.BLUE));
            gfx.renderComponentTooltip(this.font, list, pMouseX, pMouseY);
        }
        if (hover != null) {
            List<Enchantment> excls;
            list.clear();
            list.add(Component.translatable((String)hover.getEnch().getDescriptionId()).withStyle(new ChatFormatting[]{EnchantingInfoScreen.getColor(hover.getEnch()), ChatFormatting.UNDERLINE}));
            list.add(TooltipUtil.lang("info", "enchinfo_level", Component.translatable((String)("enchantment.level." + hover.getLevel()))).withStyle(ChatFormatting.DARK_AQUA));
            MutableComponent rarity = Component.translatable((String)("rarity.enchantment." + hover.getEnch().getRarity().name().toLowerCase(Locale.ROOT))).withStyle(colors[hover.getEnch().getRarity().ordinal()]);
            list.add(TooltipUtil.lang("info", "enchinfo_rarity", rarity).withStyle(ChatFormatting.DARK_AQUA));
            list.add(TooltipUtil.lang("info", "enchinfo_chance", String.format("%.2f", Float.valueOf(100.0f * (float)hover.getWeight().asInt() / (float)WeightedRandom.getTotalWeight(this.enchantments))) + "%").withStyle(ChatFormatting.DARK_AQUA));
            if (I18n.exists((String)(hover.getEnch().getDescriptionId() + ".desc"))) {
                list.add(Component.translatable((String)(hover.getEnch().getDescriptionId() + ".desc")).withStyle(ChatFormatting.DARK_AQUA));
            }
            if (!(excls = this.exclusions.get(hover.getEnch())).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i4 = 0; i4 < excls.size(); ++i4) {
                    sb.append(I18n.get((String)excls.get(i4).getDescriptionId(), (Object[])new Object[0]));
                    if (i4 == excls.size() - 1) continue;
                    sb.append(", ");
                }
                list.add(Component.translatable((String)"Exclusive With: %s", (Object[])new Object[]{sb.toString()}).withStyle(ChatFormatting.RED));
            }
            gfx.renderComponentTooltip(this.font, list, pMouseX, pMouseY);
        }
        gfx.renderFakeItem(this.toEnchant, this.leftPos + 49, this.topPos + 39);
        if (this.isHovering(49, 39, 18, 18, pMouseX, pMouseY)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)gfx, (int)(this.leftPos + 49), (int)(this.topPos + 39), (int)0);
            gfx.renderTooltip(this.font, this.toEnchant, pMouseX, pMouseY);
        }
        pose.translate(0.0f, 0.0f, -10.0f);
        for (Renderable renderable : this.renderables) {
            renderable.render(gfx, pMouseX, pMouseY, pPartialTick);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int left = this.leftPos + 220;
        int top = this.topPos + 18;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 143)) {
            this.scrolling = true;
            this.mouseDragged(pMouseX, pMouseY, 0, pMouseX, pMouseY);
        }
        for (int i = 0; i < 3; ++i) {
            Enchantment clue = Enchantment.byId((int)this.clues[i]);
            if (this.selectedSlot == i || clue == null || !this.isHovering(8, 18 + 18 * i, 18, 16, pMouseX, pMouseY)) continue;
            this.selectedSlot = i;
            this.slider.setValue((this.slider.min() + this.slider.max()) / 2);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 18;
            int j = i + 143;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pScrollY / (double)i);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.enchantments.size() > 11;
    }

    protected int getOffscreenRows() {
        return this.enchantments.size() - 11;
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && (pMouseY -= (double)j) >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    protected void recomputeEnchantments() {
        ApothEnchantmentMenu.Arcana arc = ApothEnchantmentMenu.Arcana.getForThreshold(this.parent.getMenu().stats.arcana());
        Set<Enchantment> blacklist = this.parent.getMenu().stats.blacklist();
        this.enchantments = ApothEnchantmentHelper.getAvailableEnchantmentResults(this.currentPower, this.toEnchant, this.treasure, Collections.emptySet()).stream().map(e -> new ApothEnchantmentHelper.ArcanaEnchantmentData(arc, (EnchantmentInstance)e)).map(a -> new EnchantmentDataWrapper((ApothEnchantmentHelper.ArcanaEnchantmentData)((Object)a), blacklist.contains(a.data.enchantment))).collect(Collectors.toList());
        if (this.startIndex + 11 >= this.enchantments.size()) {
            this.startIndex = 0;
            this.scrollOffs = 0.0f;
        }
        this.exclusions.clear();
        for (EnchantmentDataWrapper d : this.enchantments) {
            if (blacklist.contains(d.getEnch())) continue;
            ArrayList<Enchantment> excls = new ArrayList<Enchantment>();
            for (EnchantmentDataWrapper d2 : this.enchantments) {
                if (d == d2 || d.getEnch().isCompatibleWith(d2.getEnch())) continue;
                excls.add(d2.getEnch());
            }
            this.exclusions.put(d.getEnch(), excls);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected EnchantmentDataWrapper getHovered(double mouseX, double mouseY) {
        for (int i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            if (!this.isHovering(89, 18 + i * 13, 128, 13, mouseX, mouseY)) continue;
            EnchantmentDataWrapper data = this.enchantments.get(this.startIndex + i);
            return data.isBlacklisted ? null : data;
        }
        return null;
    }

    public static ChatFormatting getColor(Enchantment ench) {
        return ApothicEnchanting.getEnchInfo(ench).isTreasure() ? ChatFormatting.GOLD : ChatFormatting.GREEN;
    }

    public class PowerSlider
    extends AbstractSliderButton {
        public PowerSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty(), 0.0);
            if (EnchantingInfoScreen.this.selectedSlot != -1 && this.value == 0.0) {
                this.value = this.normalizeValue(EnchantingInfoScreen.this.currentPower == 0 ? (double)((this.max() + this.min()) / 2) : (double)EnchantingInfoScreen.this.currentPower);
                this.applyValue();
            }
            this.updateMessage();
        }

        protected void updateMessage() {
            this.setMessage((Component)TooltipUtil.lang("info", "slider_power", EnchantingInfoScreen.this.currentPower));
        }

        protected void applyValue() {
            EnchantingInfoScreen.this.currentPower = this.denormalizeValue(this.value);
            EnchantingInfoScreen.this.recomputeEnchantments();
        }

        public void setValue(int value) {
            if (!EnchantingInfoScreen.this.isDragging()) {
                this.value = this.normalizeValue(value);
                this.applyValue();
                this.updateMessage();
            }
        }

        public double normalizeValue(double value) {
            return Mth.clamp((double)((this.snapToStepClamp(value) - (double)this.min()) / (double)(this.max() - this.min())), (double)0.0, (double)1.0);
        }

        public int denormalizeValue(double value) {
            return (int)this.snapToStepClamp(Mth.lerp((double)Mth.clamp((double)value, (double)0.0, (double)1.0), (double)this.min(), (double)this.max()));
        }

        private double snapToStepClamp(double valueIn) {
            if (this.step() > 0.0f) {
                valueIn = this.step() * (float)Math.round(valueIn / (double)this.step());
            }
            return Mth.clamp((double)valueIn, (double)this.min(), (double)this.max());
        }

        private int min() {
            return EnchantingInfoScreen.this.powers[EnchantingInfoScreen.this.selectedSlot][0];
        }

        private int max() {
            return EnchantingInfoScreen.this.powers[EnchantingInfoScreen.this.selectedSlot][1];
        }

        private float step() {
            return 1.0f / (float)Math.max(this.max() - this.min(), 1);
        }
    }

    protected static class EnchantmentDataWrapper
    extends WeightedEntry.IntrusiveBase {
        protected final ApothEnchantmentHelper.ArcanaEnchantmentData data;
        protected final boolean isBlacklisted;

        public EnchantmentDataWrapper(ApothEnchantmentHelper.ArcanaEnchantmentData data, boolean isBlacklisted) {
            super(isBlacklisted ? 0 : data.getWeight().asInt());
            this.data = data;
            this.isBlacklisted = isBlacklisted;
        }

        public Enchantment getEnch() {
            return this.data.data.enchantment;
        }

        public int getLevel() {
            return this.data.data.level;
        }
    }
}

