/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EnchantingStatRegistry
extends DynamicRegistry<BlockStats> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatRegistry INSTANCE = new EnchantingStatRegistry();
    private final Map<Block, Stats> statsPerBlock = new HashMap<Block, Stats>();

    protected EnchantingStatRegistry() {
        super(ApothicEnchanting.LOGGER, "enchanting_stats", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(ApothicEnchanting.loc("enchanting_stats"), BlockStats.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.statsPerBlock.clear();
    }

    protected void onReload() {
        super.onReload();
        for (BlockStats bStats : this.registry.values()) {
            bStats.blocks.forEach(b -> this.statsPerBlock.put((Block)b, bStats.stats));
        }
    }

    public static float getEterna(BlockState state, Level world, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).eterna;
        }
        return state.getEnchantPowerBonus((LevelReader)world, pos) * 2.0f;
    }

    public static float getMaxEterna(BlockState state, Level world, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).maxEterna;
        }
        return ((EnchantmentStatBlock)block).getMaxEnchantingPower(state, (LevelReader)world, pos);
    }

    public static float getQuanta(BlockState state, Level world, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).quanta;
        }
        return ((EnchantmentStatBlock)block).getQuantaBonus(state, (LevelReader)world, pos);
    }

    public static float getArcana(BlockState state, Level world, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).arcana;
        }
        return ((EnchantmentStatBlock)block).getArcanaBonus(state, (LevelReader)world, pos);
    }

    public static int getBonusClues(BlockState state, Level world, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).clues;
        }
        return ((EnchantmentStatBlock)block).getBonusClues(state, (LevelReader)world, pos);
    }

    public static class BlockStats
    implements CodecProvider<BlockStats> {
        public static Codec<BlockStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.list((Codec)BuiltInRegistries.BLOCK.byNameCodec()), (String)"blocks", Collections.emptyList()).forGetter(bs -> bs.blocks), (App)ExtraCodecs.strictOptionalField((Codec)TagKey.codec((ResourceKey)Registries.BLOCK), (String)"tag").forGetter(bs -> Optional.empty()), (App)ExtraCodecs.strictOptionalField((Codec)BuiltInRegistries.BLOCK.byNameCodec(), (String)"block").forGetter(bs -> Optional.empty()), (App)Stats.CODEC.fieldOf("stats").forGetter(bs -> bs.stats)).apply((Applicative)inst, BlockStats::new));
        public final List<Block> blocks = new ArrayList<Block>();
        public final Stats stats;

        public BlockStats(List<Block> blocks, Optional<TagKey<Block>> tag, Optional<Block> block, Stats stats) {
            if (!blocks.isEmpty()) {
                this.blocks.addAll(blocks);
            }
            if (tag.isPresent()) {
                this.blocks.addAll(INSTANCE.getContext().getTag(tag.get()).stream().map(Holder::value).toList());
            }
            if (block.isPresent()) {
                this.blocks.add(block.get());
            }
            this.stats = stats;
        }

        public Codec<? extends BlockStats> getCodec() {
            return CODEC;
        }
    }

    public record Stats(float maxEterna, float eterna, float quanta, float arcana, int clues) {
        public static Codec<Stats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.FLOAT, (String)"maxEterna", (Object)Float.valueOf(15.0f)).forGetter(Stats::maxEterna), (App)ExtraCodecs.strictOptionalField((Codec)Codec.FLOAT, (String)"eterna", (Object)Float.valueOf(0.0f)).forGetter(Stats::eterna), (App)ExtraCodecs.strictOptionalField((Codec)Codec.FLOAT, (String)"quanta", (Object)Float.valueOf(0.0f)).forGetter(Stats::quanta), (App)ExtraCodecs.strictOptionalField((Codec)Codec.FLOAT, (String)"arcana", (Object)Float.valueOf(0.0f)).forGetter(Stats::arcana), (App)ExtraCodecs.strictOptionalField((Codec)Codec.INT, (String)"clues", (Object)0).forGetter(Stats::clues)).apply((Applicative)inst, Stats::new));

        public void write(FriendlyByteBuf buf) {
            buf.writeFloat(this.maxEterna);
            buf.writeFloat(this.eterna);
            buf.writeFloat(this.quanta);
            buf.writeFloat(this.arcana);
            buf.writeByte(this.clues);
        }

        public static Stats read(FriendlyByteBuf buf) {
            return new Stats(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readByte());
        }
    }
}

