/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.state.BlockState;

public record EnchantmentTableStats(float eterna, float quanta, float arcana, int clues, Set<Enchantment> blacklist, boolean treasure, boolean stable) {
    public static final EnchantmentTableStats INVALID = new EnchantmentTableStats(0.0f, 0.0f, 0.0f, 0, Collections.emptySet(), false, false);

    public EnchantmentTableStats(float eterna, float quanta, float arcana, int clues, Set<Enchantment> blacklist, boolean treasure, boolean stable) {
        this.eterna = Mth.clamp((float)eterna, (float)0.0f, (float)100.0f);
        this.quanta = Mth.clamp((float)quanta, (float)0.0f, (float)100.0f);
        this.arcana = Mth.clamp((float)arcana, (float)0.0f, (float)100.0f);
        this.clues = Math.max(clues, 0);
        this.blacklist = Collections.unmodifiableSet(blacklist);
        this.treasure = treasure;
        this.stable = stable;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.eterna);
        buf.writeFloat(this.quanta);
        buf.writeFloat(this.arcana);
        buf.writeByte(this.clues);
        buf.writeShort(this.blacklist.size());
        for (Enchantment e : this.blacklist) {
            buf.writeVarInt(BuiltInRegistries.ENCHANTMENT.getId((Object)e));
        }
        buf.writeBoolean(this.treasure);
        buf.writeBoolean(this.stable);
    }

    public static EnchantmentTableStats read(FriendlyByteBuf buf) {
        float eterna = buf.readFloat();
        float quanta = buf.readFloat();
        float arcana = buf.readFloat();
        byte clues = buf.readByte();
        int size = buf.readShort();
        HashSet<Enchantment> blacklist = new HashSet<Enchantment>(size);
        for (int i = 0; i < size; ++i) {
            blacklist.add((Enchantment)BuiltInRegistries.ENCHANTMENT.byId(buf.readVarInt()));
        }
        boolean treasure = buf.readBoolean();
        boolean stable = buf.readBoolean();
        return new EnchantmentTableStats(eterna, quanta, arcana, clues, blacklist, treasure, stable);
    }

    public static EnchantmentTableStats vanilla(int level) {
        return new EnchantmentTableStats(level, 15.0f, 0.0f, 1, Set.of(), false, false);
    }

    public static EnchantmentTableStats gatherStats(Level level, BlockPos pos, int itemEnch) {
        Builder builder = new Builder(itemEnch);
        for (BlockPos offset : EnchantmentTableBlock.BOOKSHELF_OFFSETS) {
            if (!EnchantmentTableStats.canReadStatsFrom(level, pos, offset)) continue;
            EnchantmentTableStats.gatherStats(builder, level, pos.offset((Vec3i)offset));
        }
        return builder.build();
    }

    public static boolean canReadStatsFrom(Level level, BlockPos tablePos, BlockPos offset) {
        return level.getBlockState(tablePos.offset(offset.getX() / 2, offset.getY(), offset.getZ() / 2)).is(BlockTags.ENCHANTMENT_POWER_TRANSMITTER);
    }

    public static void gatherStats(Builder builder, Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (state.isAir()) {
            return;
        }
        float eterna = EnchantingStatRegistry.getEterna(state, world, pos);
        float max = EnchantingStatRegistry.getMaxEterna(state, world, pos);
        builder.addEterna(eterna, max);
        builder.addQuanta(EnchantingStatRegistry.getQuanta(state, world, pos));
        builder.addArcana(EnchantingStatRegistry.getArcana(state, world, pos));
        builder.addClues(EnchantingStatRegistry.getBonusClues(state, world, pos));
        EnchantmentStatBlock enchBlock = (EnchantmentStatBlock)state.getBlock();
        enchBlock.getBlacklistedEnchantments(state, (LevelReader)world, pos).forEach(builder::blacklistEnchant);
        if (enchBlock.allowsTreasure(state, (LevelReader)world, pos)) {
            builder.setAllowsTreasure(true);
        }
        if (enchBlock.providesStability(state, (LevelReader)world, pos)) {
            builder.setStable(true);
        }
    }

    public static class Builder {
        private final Float2FloatMap eternaMap = new Float2FloatOpenHashMap();
        private final Set<Enchantment> blacklist = new HashSet<Enchantment>();
        private float eterna = 0.0f;
        private float quanta = 0.0f;
        private float arcana = 0.0f;
        private int clues = 0;
        private boolean allowsTreasure = false;
        private boolean stable = false;

        public Builder(int itemEnch) {
            this.addQuanta(15.0f);
            this.addArcana((float)itemEnch / 2.0f);
            this.addClues(1);
        }

        public void addEterna(float eterna, float max) {
            this.eternaMap.put(max, this.eternaMap.getOrDefault(max, 0.0f) + eterna);
        }

        public void addQuanta(float quanta) {
            this.quanta += quanta;
        }

        public void addArcana(float arcana) {
            this.arcana += arcana;
        }

        public void addClues(int clues) {
            this.clues += clues;
        }

        public void blacklistEnchant(Enchantment ench) {
            this.blacklist.add(ench);
        }

        public void setAllowsTreasure(boolean allowsTreasure) {
            this.allowsTreasure = allowsTreasure;
        }

        public void setStable(boolean stable) {
            this.stable = stable;
        }

        public EnchantmentTableStats build() {
            ArrayList entries = new ArrayList(this.eternaMap.float2FloatEntrySet());
            Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
            for (Float2FloatMap.Entry e : entries) {
                if (e.getFloatKey() > 0.0f) {
                    this.eterna = Math.min(e.getFloatKey(), this.eterna + e.getFloatValue());
                    continue;
                }
                this.eterna += e.getFloatValue();
            }
            return new EnchantmentTableStats(this.eterna, this.quanta, this.arcana, this.clues, this.blacklist, this.allowsTreasure, this.stable);
        }
    }
}

