/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table.infusion;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class InfusionRecipe
implements Recipe<Container> {
    public static final EnchantingStatRegistry.Stats NO_MAX = new EnchantingStatRegistry.Stats(-1.0f, -1.0f, -1.0f, -1.0f, -1);
    public static final Codec<InfusionRecipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(InfusionRecipe::getOutput), (App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(InfusionRecipe::getInput), (App)EnchantingStatRegistry.Stats.CODEC.fieldOf("requirements").forGetter(InfusionRecipe::getRequirements), (App)ExtraCodecs.strictOptionalField(EnchantingStatRegistry.Stats.CODEC, (String)"max_requirements", (Object)NO_MAX).forGetter(InfusionRecipe::getMaxRequirements)).apply((Applicative)inst, InfusionRecipe::new));
    public static final Serializer SERIALIZER = new Serializer();
    protected final ItemStack output;
    protected final Ingredient input;
    protected final EnchantingStatRegistry.Stats requirements;
    protected final EnchantingStatRegistry.Stats maxRequirements;

    public InfusionRecipe(ItemStack output, Ingredient input, EnchantingStatRegistry.Stats requirements, EnchantingStatRegistry.Stats maxRequirements) {
        this.output = output;
        this.input = input;
        this.requirements = requirements;
        this.maxRequirements = maxRequirements;
        if (maxRequirements.eterna() != -1.0f && requirements.eterna() > maxRequirements.eterna()) {
            throw new UnsupportedOperationException("Invalid min/max eterna bounds (min > max).");
        }
        if (maxRequirements.quanta() != -1.0f && requirements.quanta() > maxRequirements.quanta()) {
            throw new UnsupportedOperationException("Invalid min/max quanta bounds (min > max).");
        }
        if (maxRequirements.arcana() != -1.0f && requirements.arcana() > maxRequirements.arcana()) {
            throw new UnsupportedOperationException("Invalid min/max arcana bounds (min > max).");
        }
    }

    public boolean matches(ItemStack input, float eterna, float quanta, float arcana) {
        if (this.maxRequirements.eterna() > -1.0f && eterna > this.maxRequirements.eterna() || this.maxRequirements.quanta() > -1.0f && quanta > this.maxRequirements.quanta() || this.maxRequirements.arcana() > -1.0f && arcana > this.maxRequirements.arcana()) {
            return false;
        }
        return this.input.test(input) && eterna >= this.requirements.eterna() && quanta >= this.requirements.quanta() && arcana >= this.requirements.arcana();
    }

    public EnchantingStatRegistry.Stats getRequirements() {
        return this.requirements;
    }

    public EnchantingStatRegistry.Stats getMaxRequirements() {
        return this.maxRequirements;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    @Deprecated
    public boolean matches(Container pContainer, Level pLevel) {
        return false;
    }

    @Deprecated
    public ItemStack assemble(Container pContainer, RegistryAccess regs) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Deprecated
    public ItemStack getResultItem(RegistryAccess regs) {
        return this.output;
    }

    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return Ench.RecipeTypes.INFUSION.get();
    }

    protected static Pair<EnchantingStatRegistry.Stats, EnchantingStatRegistry.Stats> readStats(ResourceLocation id, JsonObject obj) {
        EnchantingStatRegistry.Stats maxStats;
        EnchantingStatRegistry.Stats stats = (EnchantingStatRegistry.Stats)Util.getOrThrow((DataResult)EnchantingStatRegistry.Stats.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("requirements")), JsonParseException::new);
        EnchantingStatRegistry.Stats stats2 = maxStats = obj.has("max_requirements") ? (EnchantingStatRegistry.Stats)Util.getOrThrow((DataResult)EnchantingStatRegistry.Stats.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("max_requirements")), JsonParseException::new) : NO_MAX;
        if (maxStats.eterna() != -1.0f && stats.eterna() > maxStats.eterna()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max eterna bounds (min > max).");
        }
        if (maxStats.quanta() != -1.0f && stats.quanta() > maxStats.quanta()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max quanta bounds (min > max).");
        }
        if (maxStats.arcana() != -1.0f && stats.arcana() > maxStats.arcana()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max arcana bounds (min > max).");
        }
        return Pair.of((Object)stats, (Object)maxStats);
    }

    @Nullable
    public static InfusionRecipe findMatch(Level level, ItemStack input, float eterna, float quanta, float arcana) {
        return level.getRecipeManager().getAllRecipesFor(Ench.RecipeTypes.INFUSION.get()).stream().map(RecipeHolder::value).sorted((r1, r2) -> -Float.compare(r1.requirements.eterna(), r2.requirements.eterna())).filter(r -> r.matches(input, eterna, quanta, arcana)).findFirst().orElse(null);
    }

    @Nullable
    public static InfusionRecipe findItemMatch(Level level, ItemStack toEnchant) {
        return level.getRecipeManager().getAllRecipesFor(Ench.RecipeTypes.INFUSION.get()).stream().map(RecipeHolder::value).filter(r -> r.getInput().test(toEnchant)).findFirst().orElse(null);
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        public Codec<InfusionRecipe> codec() {
            return CODEC;
        }

        public InfusionRecipe fromNetwork(FriendlyByteBuf buf) {
            ItemStack output = buf.readItem();
            Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            EnchantingStatRegistry.Stats stats = EnchantingStatRegistry.Stats.read(buf);
            EnchantingStatRegistry.Stats maxStats = buf.readBoolean() ? EnchantingStatRegistry.Stats.read(buf) : NO_MAX;
            return new InfusionRecipe(output, input, stats, maxStats);
        }

        public void toNetwork(FriendlyByteBuf buf, InfusionRecipe recipe) {
            buf.writeItem(recipe.output);
            recipe.input.toNetwork(buf);
            recipe.requirements.write(buf);
            buf.writeBoolean(recipe.maxRequirements != NO_MAX);
            if (recipe.maxRequirements != NO_MAX) {
                recipe.maxRequirements.write(buf);
            }
        }
    }
}

