/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.util;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_enchanting.Ench;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.NBTIngredient;

public class MiscDatagen
implements DataProvider {
    private final Path outputDir;
    private CachedOutput cachedOutput;
    private List<CompletableFuture<?>> futures = new ArrayList();

    public MiscDatagen(Path outputDir) {
        this.outputDir = outputDir;
    }

    private void genRecipes() {
        Ingredient pot = MiscDatagen.potionIngredient(Potions.REGENERATION);
        this.addShaped(Ench.Blocks.HELLSHELF.get(), 3, 3, Blocks.NETHER_BRICKS, Blocks.NETHER_BRICKS, Blocks.NETHER_BRICKS, Items.BLAZE_ROD, "forge:bookshelves", pot, Blocks.NETHER_BRICKS, Blocks.NETHER_BRICKS, Blocks.NETHER_BRICKS);
        this.addShaped(Ench.Items.PRISMATIC_WEB, 3, 3, null, Items.PRISMARINE_SHARD, null, Items.PRISMARINE_SHARD, Blocks.COBWEB, Items.PRISMARINE_SHARD, null, Items.PRISMARINE_SHARD, null);
        ItemStack book = new ItemStack((ItemLike)Items.BOOK);
        ItemStack stick = new ItemStack((ItemLike)Items.STICK);
        ItemStack blaze = new ItemStack((ItemLike)Items.BLAZE_ROD);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.HELMET_TOME.get(), 5), 3, 2, book, book, book, book, blaze, book);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.CHESTPLATE_TOME.get(), 8), 3, 3, book, blaze, book, book, book, book, book, book, book);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.LEGGINGS_TOME.get(), 7), 3, 3, book, null, book, book, blaze, book, book, book, book);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.BOOTS_TOME.get(), 4), 3, 2, book, null, book, book, blaze, book);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.WEAPON_TOME.get(), 2), 1, 3, book, book, new ItemStack((ItemLike)Items.BLAZE_POWDER));
        this.addShaped(new ItemStack((ItemLike)Ench.Items.PICKAXE_TOME.get(), 3), 3, 3, book, book, book, null, blaze, null, null, stick, null);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.FISHING_TOME.get(), 2), 3, 3, null, null, blaze, null, stick, book, stick, null, book);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.BOW_TOME.get(), 3), 3, 3, null, stick, book, blaze, null, book, null, stick, book);
        this.addShapeless(new ItemStack((ItemLike)Ench.Items.OTHER_TOME.get(), 6), book, book, book, book, book, book, blaze);
        this.addShaped(new ItemStack((ItemLike)Ench.Items.SCRAP_TOME.get(), 8), 3, 3, book, book, book, book, Blocks.ANVIL, book, book, book, book);
        Ingredient maxHellshelf = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Ench.Blocks.INFUSED_HELLSHELF.get()});
        this.addShaped(Ench.Blocks.BLAZING_HELLSHELF.get(), 3, 3, null, Items.FIRE_CHARGE, null, Items.FIRE_CHARGE, maxHellshelf, Items.FIRE_CHARGE, Items.BLAZE_POWDER, Items.BLAZE_POWDER, Items.BLAZE_POWDER);
        this.addShaped(Ench.Blocks.GLOWING_HELLSHELF.get(), 3, 3, null, Blocks.GLOWSTONE, null, null, maxHellshelf, null, Blocks.GLOWSTONE, null, Blocks.GLOWSTONE);
        this.addShaped(Ench.Blocks.SEASHELF.get(), 3, 3, Blocks.PRISMARINE_BRICKS, Blocks.PRISMARINE_BRICKS, Blocks.PRISMARINE_BRICKS, MiscDatagen.potionIngredient(Potions.WATER), "forge:bookshelves", Items.PUFFERFISH, Blocks.PRISMARINE_BRICKS, Blocks.PRISMARINE_BRICKS, Blocks.PRISMARINE_BRICKS);
        Ingredient maxSeashelf = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Ench.Blocks.INFUSED_SEASHELF.get()});
        this.addShaped(Ench.Blocks.CRYSTAL_SEASHELF.get(), 3, 3, null, Items.PRISMARINE_CRYSTALS, null, null, maxSeashelf, null, Items.PRISMARINE_CRYSTALS, null, Items.PRISMARINE_CRYSTALS);
        this.addShaped(Ench.Blocks.HEART_SEASHELF.get(), 3, 3, null, Items.HEART_OF_THE_SEA, null, Items.PRISMARINE_SHARD, maxSeashelf, Items.PRISMARINE_SHARD, Items.PRISMARINE_SHARD, Items.PRISMARINE_SHARD, Items.PRISMARINE_SHARD);
        this.addShaped(Ench.Blocks.PEARL_ENDSHELF.get(), 3, 3, Items.END_ROD, null, Items.END_ROD, Items.ENDER_PEARL, Ench.Blocks.ENDSHELF.get(), Items.ENDER_PEARL, Items.END_ROD, null, Items.END_ROD);
        this.addShaped(Ench.Blocks.DRACONIC_ENDSHELF.get(), 3, 3, null, Items.DRAGON_HEAD, null, Items.ENDER_PEARL, Ench.Blocks.ENDSHELF.get(), Items.ENDER_PEARL, Items.ENDER_PEARL, Items.ENDER_PEARL, Items.ENDER_PEARL);
        this.addShaped(Ench.Blocks.BEESHELF.get(), 3, 3, Items.HONEYCOMB, Items.BEEHIVE, Items.HONEYCOMB, Items.HONEY_BLOCK, "forge:bookshelves", Items.HONEY_BLOCK, Items.HONEYCOMB, Items.BEEHIVE, Items.HONEYCOMB);
        this.addShaped(Ench.Blocks.MELONSHELF.get(), 3, 3, Items.MELON, Items.MELON, Items.MELON, Items.GLISTERING_MELON_SLICE, "forge:bookshelves", Items.GLISTERING_MELON_SLICE, Items.MELON, Items.MELON, Items.MELON);
        this.addShaped(Ench.Blocks.GEODE_SHELF.get(), 3, 3, Items.CALCITE, Items.CALCITE, Items.CALCITE, Items.CALCITE, "forge:bookshelves", Items.CALCITE, Items.CALCITE, Items.BUDDING_AMETHYST, Items.CALCITE);
    }

    public static ItemStack makeStack(Object thing) {
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            return stack;
        }
        if (thing instanceof ItemLike) {
            ItemLike il = (ItemLike)thing;
            return new ItemStack(il);
        }
        if (thing instanceof Holder) {
            Holder h = (Holder)thing;
            return new ItemStack((ItemLike)h.value());
        }
        throw new IllegalArgumentException("Attempted to create an ItemStack from something that cannot be converted: " + thing);
    }

    public static NonNullList<Ingredient> createInput(String modid, boolean allowEmpty, Object ... inputArr) {
        NonNullList inputL = NonNullList.create();
        for (int i = 0; i < inputArr.length; ++i) {
            ItemStack stack;
            Object input = inputArr[i];
            if (input instanceof TagKey) {
                TagKey tag = (TagKey)input;
                inputL.add(i, (Object)Ingredient.of((TagKey)tag));
                continue;
            }
            if (input instanceof String) {
                String str = (String)input;
                inputL.add(i, (Object)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation(str))));
                continue;
            }
            if (input instanceof ItemStack && !(stack = (ItemStack)input).isEmpty()) {
                inputL.add(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{stack}));
                continue;
            }
            if (input instanceof ItemLike || input instanceof Holder) {
                inputL.add(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{MiscDatagen.makeStack(input)}));
                continue;
            }
            if (input instanceof Ingredient) {
                Ingredient ing = (Ingredient)input;
                inputL.add(i, (Object)ing);
                continue;
            }
            if (allowEmpty) {
                inputL.add(i, (Object)Ingredient.EMPTY);
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid recipe.  Complain to the author of " + modid + ". (Input " + input + " not allowed.)");
        }
        return inputL;
    }

    public static ShapedRecipePattern toPattern(int width, int height, NonNullList<Ingredient> input) {
        HashMap<Character, Ingredient> key = new HashMap<Character, Ingredient>();
        HashMap<IngredientKey, Character> chars = new HashMap<IngredientKey, Character>();
        ArrayList<String> rows = new ArrayList<String>(height);
        for (int h = 0; h < height; ++h) {
            Object row = "";
            for (int w = 0; w < width; ++w) {
                Ingredient ing = (Ingredient)input.get(h * width + w);
                IngredientKey iKey = new IngredientKey(ing);
                if (chars.containsKey(iKey)) {
                    row = (String)row + chars.get(iKey);
                    continue;
                }
                Character c = MiscDatagen.getFirstChar(chars.values(), ing);
                key.put(c, ing);
                chars.put(iKey, c);
                row = (String)row + c;
            }
            rows.add((String)row);
        }
        key.remove(Character.valueOf(' '));
        return ShapedRecipePattern.of(key, rows);
    }

    private static Character getFirstChar(Collection<Character> inUse, Ingredient ing) {
        String path;
        if (ing == Ingredient.EMPTY) {
            return Character.valueOf(' ');
        }
        if (ing instanceof NBTIngredient) {
            NBTIngredient nbt = (NBTIngredient)ing;
            path = BuiltInRegistries.ITEM.getKey((Object)nbt.getItems()[0].getItem()).getPath();
        } else {
            Ingredient.Value v = ing.values[0];
            if (v instanceof Ingredient.TagValue) {
                Ingredient.TagValue t = (Ingredient.TagValue)v;
                path = t.tag().location().getPath();
            } else if (v instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue i = (Ingredient.ItemValue)v;
                path = BuiltInRegistries.ITEM.getKey((Object)i.item().getItem()).getPath();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        path = path.toUpperCase(Locale.ROOT);
        for (char c : path.toCharArray()) {
            if (inUse.contains(Character.valueOf(c))) continue;
            return Character.valueOf(c);
        }
        throw new UnsupportedOperationException();
    }

    private ShapedRecipe genShaped(ItemStack output, int width, int height, Object ... input) {
        if (width * height != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.");
        }
        return new ShapedRecipe("apothic_enchanting", CraftingBookCategory.MISC, MiscDatagen.toPattern(width, height, MiscDatagen.createInput("apothic_enchanting", true, input)), output);
    }

    public void addShaped(Object output, int width, int height, Object ... input) {
        ItemStack out = MiscDatagen.makeStack(output);
        ShapedRecipe recipe = this.genShaped(out, width, height, input);
        this.write(recipe, ShapedRecipe.CODEC, "recipes", BuiltInRegistries.ITEM.getKey((Object)out.getItem()).getPath());
    }

    public void addShapeless(Object output, Object ... inputs) {
        ItemStack out = MiscDatagen.makeStack(output);
        ShapelessRecipe recipe = new ShapelessRecipe("apothic_enchanting", CraftingBookCategory.MISC, out, MiscDatagen.createInput("apothic_enchanting", false, inputs));
        this.write(recipe, ShapelessRecipe.CODEC, "recipes", BuiltInRegistries.ITEM.getKey((Object)out.getItem()).getPath());
    }

    private <T> void write(T object, Codec<T> codec, String type, String path) {
        this.futures.add(DataProvider.saveStable((CachedOutput)this.cachedOutput, codec, object, (Path)this.outputDir.resolve(type + "/" + path + ".json")));
    }

    public static Ingredient potionIngredient(Potion type) {
        return new NBTIngredient(Set.of(Items.POTION), PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)type).getTag(), false){};
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.cachedOutput = pOutput;
        this.genRecipes();
        return CompletableFuture.allOf((CompletableFuture[])this.futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "apothic_enchanting";
    }

    private static class IngredientKey {
        private final Ingredient ing;

        private IngredientKey(Ingredient ing) {
            this.ing = ing;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IngredientKey) {
                IngredientKey key = (IngredientKey)obj;
                Ingredient.Value[] ours = this.ing.values;
                Ingredient.Value[] theirs = key.ing.values;
                if (ours.length != theirs.length) {
                    return false;
                }
                for (int i = 0; i < ours.length; ++i) {
                    if (ours[i].equals(theirs[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 31;
            for (Ingredient.Value v : this.ing.values) {
                if (v instanceof Ingredient.TagValue) {
                    Ingredient.TagValue t = (Ingredient.TagValue)v;
                    hash ^= t.hashCode();
                    continue;
                }
                if (v instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue i = (Ingredient.ItemValue)v;
                    hash ^= BuiltInRegistries.ITEM.getKey((Object)i.item().getItem()).hashCode();
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return hash;
        }
    }
}

