/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.util;

import com.mojang.authlib.GameProfile;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.EventHooks;

public class MiscUtil {
    public static int getExpCostForSlot(int level, int slot) {
        int cost = 0;
        for (int i = 0; i <= slot; ++i) {
            cost += EnchantmentUtils.getExperienceForLevel((int)(level - i));
        }
        return cost - 1;
    }

    public static int[] doubleUpGradient(int[] data) {
        int[] out = new int[data.length * 2];
        System.arraycopy(data, 0, out, 0, data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            out[data.length * 2 - 1 - i] = data[i];
        }
        return out;
    }

    public static boolean isOnCooldown(ResourceLocation id, int cooldown, LivingEntity entity) {
        long lastApplied = entity.getPersistentData().getLong("apothic_enchanting.cooldown." + id.toString());
        return lastApplied != 0L && lastApplied + (long)cooldown >= entity.level().getGameTime();
    }

    public static void startCooldown(ResourceLocation id, LivingEntity entity) {
        entity.getPersistentData().putLong("apothic_enchanting.cooldown." + id.toString(), entity.level().getGameTime());
    }

    public static boolean breakExtraBlock(ServerLevel world, BlockPos pos, ItemStack mainhand, @Nullable UUID source) {
        boolean removed;
        FakePlayer player;
        BlockState blockstate = world.getBlockState(pos);
        if (source != null) {
            player = FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(source, UsernameCache.getLastKnownUsername((UUID)source)));
            Player realPlayer = world.getPlayerByUUID(source);
            if (realPlayer != null) {
                player.setPos(realPlayer.position());
            }
        } else {
            player = FakePlayerFactory.getMinecraft((ServerLevel)world);
        }
        player.getInventory().items.set(player.getInventory().selected, (Object)mainhand);
        if (blockstate.getDestroySpeed((BlockGetter)world, pos) < 0.0f || !blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player)) {
            return false;
        }
        GameType type = player.getAbilities().instabuild ? GameType.CREATIVE : GameType.SURVIVAL;
        int exp = CommonHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity tileentity = world.getBlockEntity(pos);
        Block block = blockstate.getBlock();
        if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.canUseGameMasterBlocks()) {
            world.sendBlockUpdated(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.getMainHandItem().onBlockStartBreak(pos, (Player)player)) {
            return false;
        }
        if (player.blockActionRestricted((Level)world, pos, type)) {
            return false;
        }
        if (player.getAbilities().instabuild) {
            MiscUtil.removeBlock(world, (ServerPlayer)player, pos, false);
            return true;
        }
        ItemStack itemstack = player.getMainHandItem();
        ItemStack itemstack1 = itemstack.copy();
        boolean canHarvest = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
        itemstack.mineBlock((Level)world, blockstate, pos, (Player)player);
        if (itemstack.isEmpty() && !itemstack1.isEmpty()) {
            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        if ((removed = MiscUtil.removeBlock(world, (ServerPlayer)player, pos, canHarvest)) && canHarvest) {
            block.playerDestroy((Level)world, (Player)player, pos, blockstate, tileentity, itemstack1);
        }
        if (removed && exp > 0) {
            blockstate.getBlock().popExperience(world, pos, exp);
        }
        return true;
    }

    public static boolean removeBlock(ServerLevel world, ServerPlayer player, BlockPos pos, boolean canHarvest) {
        BlockState state = world.getBlockState(pos);
        boolean removed = state.onDestroyedByPlayer((Level)world, pos, (Player)player, canHarvest, world.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)world, pos, state);
        }
        return removed;
    }
}

