/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.farmingforblockheads.block.entity.FeedingTroughBlockEntity;
import net.blay09.mods.farmingforblockheads.block.entity.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FeedingTroughBlock
extends BaseEntityBlock {
    public static final MapCodec<FeedingTroughBlock> CODEC = FeedingTroughBlock.simpleCodec(FeedingTroughBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape RENDER_SHAPE = SHAPE.move(0.0, 0.01, 0.0);

    protected FeedingTroughBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD).strength(2.0f));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FeedingTroughBlockEntity(pos, state);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (!level.isClientSide) {
            ItemStack heldItem = player.getItemInHand(hand);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FeedingTroughBlockEntity) {
                FeedingTroughBlockEntity feedingTrough = (FeedingTroughBlockEntity)blockEntity;
                Container container = feedingTrough.getContainer();
                if (player.isShiftKeyDown()) {
                    if (heldItem.isEmpty()) {
                        player.setItemInHand(hand, ContainerUtils.extractItem((Container)container, (int)0, (int)64, (boolean)false));
                    } else {
                        ItemStack restStack = ContainerUtils.extractItem((Container)container, (int)0, (int)64, (boolean)false);
                        if (!player.getInventory().add(restStack)) {
                            ContainerUtils.insertItemStacked((Container)container, (ItemStack)restStack, (boolean)false);
                        }
                    }
                } else {
                    ItemStack restStack = ContainerUtils.insertItemStacked((Container)container, (ItemStack)heldItem, (boolean)false);
                    player.setItemInHand(hand, restStack);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.isClientSide && !state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof FeedingTroughBlockEntity) {
            FeedingTroughBlockEntity feedingTrough = (FeedingTroughBlockEntity)blockEntity;
            Container container = feedingTrough.getContainer();
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack itemStack = container.getItem(i);
                if (itemStack.isEmpty()) continue;
                level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), itemStack.copy()));
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void appendHoverText(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.farmingforblockheads.feeding_trough").withStyle(ChatFormatting.GRAY));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return RENDER_SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : FeedingTroughBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.feedingTrough.get()), FeedingTroughBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

