/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block.entity;

import java.util.Set;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.farmingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarketBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider {
    public MarketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.market.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.farmingforblockheads.market");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new MarketMenu(windowId, playerInventory, this.worldPosition, MarketBlockEntity.getPresetFilter(), MarketBlockEntity.getCategoryFilter());
    }

    @NotNull
    private static Set<ResourceLocation> getCategoryFilter() {
        return Set.of();
    }

    @NotNull
    private static Set<ResourceLocation> getPresetFilter() {
        return Set.of();
    }

    public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
        buf.writeBlockPos(this.worldPosition);
        Set<ResourceLocation> presetFilter = MarketBlockEntity.getPresetFilter();
        buf.writeInt(presetFilter.size());
        for (ResourceLocation location : presetFilter) {
            buf.writeResourceLocation(location);
        }
        Set<ResourceLocation> categoryFilter = MarketBlockEntity.getCategoryFilter();
        buf.writeInt(categoryFilter.size());
        for (ResourceLocation location : categoryFilter) {
            buf.writeResourceLocation(location);
        }
    }
}

