/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.blay09.mods.farmingforblockheads.compat.emi.EmiIntegration;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class MarketEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;

    public MarketEmiRecipe(ResourceLocation id, MarketRecipe recipe) {
        this.id = id;
        this.input = List.of(EmiIngredient.of((Ingredient)recipe.getPaymentOrDefault().ingredient(), (long)recipe.getPaymentOrDefault().count()));
        this.output = List.of(EmiStack.of((ItemStack)recipe.getResultItem((RegistryAccess)RegistryAccess.EMPTY)));
    }

    public EmiRecipeCategory getCategory() {
        return EmiIntegration.MARKET_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 86;
    }

    public int getDisplayHeight() {
        return 48;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiIntegration.BACKGROUND, 0, 0);
        widgets.addSlot(this.input.get(0), 15, 12);
        widgets.addSlot((EmiIngredient)this.output.get(0), 53, 12).recipeContext((EmiRecipe)this);
        widgets.addTexture(EmiIntegration.TRADE_ICON, 35, 13);
    }
}

