/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryImpl;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MarketCategoriesMessage {
    private final Map<ResourceLocation, MarketCategory> categories;

    public MarketCategoriesMessage(Map<ResourceLocation, MarketCategory> categories) {
        this.categories = categories;
    }

    public static MarketCategoriesMessage decode(FriendlyByteBuf buf) {
        int count = buf.readInt();
        HashMap<ResourceLocation, MarketCategory> categories = new HashMap<ResourceLocation, MarketCategory>();
        for (int i = 0; i < count; ++i) {
            ResourceLocation id = buf.readResourceLocation();
            ItemStack iconStack = buf.readItem();
            int sortIndex = buf.readInt();
            Component tooltip = buf.readComponent();
            MarketCategoryImpl category = new MarketCategoryImpl(iconStack, sortIndex, tooltip);
            categories.put(id, category);
        }
        return new MarketCategoriesMessage(categories);
    }

    public static void encode(MarketCategoriesMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.categories.size());
        message.categories.forEach((id, category) -> {
            buf.writeResourceLocation(id);
            buf.writeItem(category.iconStack());
            buf.writeInt(category.sortIndex());
            buf.writeComponent(category.tooltip());
        });
    }

    public static void handle(Player player, MarketCategoriesMessage message) {
        MarketCategoryRegistry.INSTANCE.load(message.categories);
    }
}

