/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.blay09.mods.farmingforblockheads.api.MarketPreset;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetRegistry;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MarketRecipe
implements Recipe<Container> {
    private final ResourceLocation preset;
    private final ResourceLocation category;
    private final ItemStack resultItem;
    private final Payment payment;

    public MarketRecipe(ItemStack resultItem, ResourceLocation category, ResourceLocation preset, Optional<Payment> payment) {
        this.preset = preset;
        this.category = category;
        this.resultItem = resultItem;
        this.payment = payment.orElse(null);
    }

    public boolean matches(Container container, Level level) {
        return true;
    }

    public ItemStack assemble(Container container, RegistryAccess registryAccess) {
        return this.resultItem.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.resultItem;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.marketRecipeSerializer;
    }

    public RecipeType<?> getType() {
        return ModRecipes.marketRecipeType;
    }

    public ResourceLocation getPreset() {
        return this.preset;
    }

    public ResourceLocation getCategory() {
        return this.category;
    }

    private Payment getDefaultPayment(ResourceLocation presetId) {
        return MarketPresetRegistry.INSTANCE.get(presetId).map(MarketPreset::payment).orElseGet(() -> new PaymentImpl(Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD}), 1, Optional.empty()));
    }

    public Payment getPaymentOrDefault() {
        return this.payment != null ? this.payment : this.getDefaultPayment(this.preset);
    }

    static class Serializer
    implements RecipeSerializer<MarketRecipe> {
        private static final Codec<ItemStack> RESULT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").orElse((Object)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.AIR)).forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"count", (Object)1).forGetter(ItemStack::getCount), (App)CompoundTag.CODEC.optionalFieldOf("tag").forGetter(itemStack -> Optional.ofNullable(itemStack.getTag()))).apply((Applicative)instance, ItemStack::new));
        private static final Codec<MarketRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RESULT_CODEC.fieldOf("result").forGetter(recipe -> recipe.resultItem), (App)ResourceLocation.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)ResourceLocation.CODEC.fieldOf("preset").forGetter(recipe -> recipe.preset), (App)PaymentImpl.CODEC.optionalFieldOf("payment").forGetter(recipe -> Optional.ofNullable(recipe.payment))).apply((Applicative)instance, MarketRecipe::new));

        Serializer() {
        }

        public Codec<MarketRecipe> codec() {
            return CODEC;
        }

        public MarketRecipe fromNetwork(FriendlyByteBuf buf) {
            ItemStack resultItem = buf.readItem();
            ResourceLocation category = buf.readResourceLocation();
            ResourceLocation preset = buf.readResourceLocation();
            Payment payment = PaymentImpl.fromNetwork(buf);
            return new MarketRecipe(resultItem, category, preset, Optional.of(payment));
        }

        public void toNetwork(FriendlyByteBuf buf, MarketRecipe recipe) {
            buf.writeItem(recipe.resultItem);
            buf.writeResourceLocation(recipe.category);
            buf.writeResourceLocation(recipe.preset);
            PaymentImpl.toNetwork(buf, recipe.getPaymentOrDefault());
        }
    }
}

