/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryRegistry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class MarketCategoryLoader
implements ResourceManagerReloadListener {
    private static final FileToIdConverter MARKET_CATEGORIES = FileToIdConverter.json((String)"market_categories");

    public void onResourceManagerReload(ResourceManager resourceManager) {
        MarketCategoryRegistry registry = MarketCategoryRegistry.INSTANCE;
        registry.clear();
        for (Map.Entry entry : MARKET_CATEGORIES.listMatchingResources(resourceManager).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    ResourceLocation id = MARKET_CATEGORIES.fileToId((ResourceLocation)entry.getKey());
                    registry.loadAdditionally(id, reader);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market category file at {}", entry.getKey(), (Object)e);
            }
        }
        File configDir = new File(Balm.getConfig().getConfigDir(), "market_categories");
        if (configDir.exists() || configDir.mkdirs()) {
            try (Stream<Path> files = Files.walk(configDir.toPath(), new FileVisitOption[0]);){
                files.filter(it -> it.getFileName().endsWith(".json")).forEach(it -> {
                    ResourceLocation id = new ResourceLocation("farmingforblockheads", it.getFileName().toString().replace(".json", ""));
                    try (BufferedReader reader = Files.newBufferedReader(it);){
                        registry.loadAdditionally(id, reader);
                    }
                    catch (Exception e) {
                        FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market category file at {}", it, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market category files from {}", (Object)configDir, (Object)e);
            }
        }
    }

    public void onLogin(PlayerLoginEvent event) {
    }
}

