/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.network.MarketCategoriesMessage;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryImpl;
import net.minecraft.Util;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MarketCategoryRegistry {
    private static final Codec<MarketCategory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ADVANCEMENT_ICON_CODEC.fieldOf("icon").forGetter(MarketCategory::iconStack), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"sortIndex", (Object)0).forGetter(MarketCategory::sortIndex), (App)ComponentSerialization.CODEC.fieldOf("tooltip").forGetter(MarketCategory::tooltip)).apply((Applicative)instance, MarketCategoryImpl::new));
    public static final MarketCategoryRegistry INSTANCE = new MarketCategoryRegistry();
    private final Map<ResourceLocation, MarketCategory> categories = new HashMap<ResourceLocation, MarketCategory>();

    public void register(ResourceLocation id, MarketCategory category) {
        this.categories.put(id, category);
    }

    public Map<ResourceLocation, MarketCategory> getAll() {
        return MarketCategoryRegistry.INSTANCE.categories;
    }

    public Optional<MarketCategory> get(ResourceLocation id) {
        return Optional.ofNullable(MarketCategoryRegistry.INSTANCE.categories.get(id));
    }

    public void clear() {
        this.categories.clear();
    }

    public void loadAdditionally(ResourceLocation id, BufferedReader reader) {
        Gson gson = new Gson();
        JsonElement json = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        MarketCategory category = (MarketCategory)Util.getOrThrow((DataResult)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new);
        this.register(id, category);
    }

    public void load(Map<ResourceLocation, MarketCategory> categories) {
        this.categories.clear();
        categories.forEach(this::register);
    }

    public void onLogin(PlayerLoginEvent event) {
        Balm.getNetworking().sendTo((Player)event.getPlayer(), (Object)new MarketCategoriesMessage(this.categories));
    }
}

