/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.farmingforblockheads.api.MarketPreset;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetImpl;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public class MarketPresetRegistry {
    private static final Codec<MarketPreset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PaymentImpl.CODEC.fieldOf("payment").forGetter(MarketPreset::payment), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"enabled", (Object)true).forGetter(MarketPreset::enabledByDefault)).apply((Applicative)instance, MarketPresetImpl::new));
    public static final MarketPresetRegistry INSTANCE = new MarketPresetRegistry();
    private final Map<ResourceLocation, MarketPreset> presets = new HashMap<ResourceLocation, MarketPreset>();

    public void register(ResourceLocation id, MarketPreset preset) {
        this.presets.put(id, preset);
    }

    public Collection<MarketPreset> getAll() {
        return MarketPresetRegistry.INSTANCE.presets.values();
    }

    public Optional<MarketPreset> get(ResourceLocation id) {
        return Optional.ofNullable(MarketPresetRegistry.INSTANCE.presets.get(id));
    }

    public void clear() {
        this.presets.clear();
    }

    public void loadAdditionally(ResourceLocation id, BufferedReader reader) {
        Gson gson = new Gson();
        JsonElement json = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        MarketPreset category = (MarketPreset)Util.getOrThrow((DataResult)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new);
        this.register(id, category);
    }
}

