/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.item.crafting.Ingredient;

public record PaymentImpl(Ingredient ingredient, int count, Optional<Component> tooltip) implements Payment
{
    public static final Codec<Payment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(Payment::ingredient), (App)Codec.INT.fieldOf("count").forGetter(Payment::count), (App)ComponentSerialization.CODEC.optionalFieldOf("tooltip").forGetter(Payment::tooltip)).apply((Applicative)instance, PaymentImpl::new));

    public static Payment fromNetwork(FriendlyByteBuf buf) {
        Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buf);
        int count = buf.readVarInt();
        Optional<Component> tooltip = Optional.ofNullable(buf.readBoolean() ? buf.readComponent() : null);
        return new PaymentImpl(ingredient, count, tooltip);
    }

    public static void toNetwork(FriendlyByteBuf buf, Payment payment) {
        payment.ingredient().toNetwork(buf);
        buf.writeVarInt(payment.count());
        buf.writeBoolean(payment.tooltip().isPresent());
        payment.tooltip().ifPresent(arg_0 -> ((FriendlyByteBuf)buf).writeComponent(arg_0));
    }
}

