/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screenbuilder;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Optional;
import net.creeperhost.polylib.client.fluid.ScreenFluidRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

@Deprecated(forRemoval=true)
public class ScreenBuilder {
    public static final ResourceLocation DEFAULT_RESOURCE_LOCATION = new ResourceLocation("polylib", "textures/gui_sheet.png");
    public final ResourceLocation resourceLocation;
    public Minecraft mc = Minecraft.getInstance();

    public ScreenBuilder() {
        this.resourceLocation = DEFAULT_RESOURCE_LOCATION;
    }

    public ScreenBuilder(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void drawDefaultBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, int textureXSize, int textureYSize) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        guiGraphics.blit(this.resourceLocation, x, y, 0.0f, 0.0f, width / 2, height / 2, textureXSize, textureYSize);
        guiGraphics.blit(this.resourceLocation, x + width / 2, y, (float)(150 - width / 2), 0.0f, width / 2, height / 2, textureXSize, textureYSize);
        guiGraphics.blit(this.resourceLocation, x, y + height / 2, 0.0f, (float)(150 - height / 2), width / 2, height / 2, textureXSize, textureYSize);
        guiGraphics.blit(this.resourceLocation, x + width / 2, y + height / 2, (float)(150 - width / 2), (float)(150 - height / 2), width / 2, height / 2, textureXSize, textureYSize);
    }

    public void drawPlayerSlots(GuiGraphics guiGraphics, int posX, int posY, boolean center, int textureXSize, int textureYSize) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                guiGraphics.blit(this.resourceLocation, posX + x * 18, posY + y * 18, 150.0f, 0.0f, 18, 18, textureXSize, textureYSize);
            }
        }
        for (int x = 0; x < 9; ++x) {
            guiGraphics.blit(this.resourceLocation, posX + x * 18, posY + 58, 150.0f, 0.0f, 18, 18, textureXSize, textureYSize);
        }
    }

    public void drawSlot(GuiGraphics guiGraphics, int posX, int posY, int textureXSize, int textureYSize) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        guiGraphics.blit(this.resourceLocation, posX, posY, 150.0f, 0.0f, 18, 18, textureXSize, textureYSize);
    }

    public void drawProgressBar(GuiGraphics guiGraphics, int progress, int maxProgress, int x, int y, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        guiGraphics.blit(this.resourceLocation, x, y, 150.0f, 18.0f, 23, 15, 256, 256);
        int j = (int)((double)progress / (double)maxProgress * 24.0);
        if (j < 0) {
            j = 0;
        }
        guiGraphics.blit(this.resourceLocation, x, y, 173.0f, 18.0f, j, 16, 256, 256);
        if (this.isInRect(x, y, 26, 15, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.literal((String)(this.getPercentageColour(percentage) + percentage + "%")));
            guiGraphics.renderTooltip(this.mc.font, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public void drawTankWithOverlay(GuiGraphics guiGraphics, FluidStack fluidStack, int capacity, int x, int y, int height, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        guiGraphics.blit(this.resourceLocation, x, y, 228.0f, 18.0f, 22, 56, 256, 256);
        ScreenFluidRenderer screenFluidRenderer = new ScreenFluidRenderer(capacity, 16, height, 0);
        screenFluidRenderer.render(x + 3, y + 3, fluidStack);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        guiGraphics.blit(this.resourceLocation, x + 3, y + 3, 231.0f, 74.0f, 16, 50, 256, 256);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (fluidStack.getFluid() != null) {
                list.add(Component.literal((String)(fluidStack.getAmount() + " / " + capacity + " " + fluidStack.getName().getString())));
            } else {
                list.add(Component.literal((String)"empty"));
            }
            guiGraphics.renderTooltip(this.mc.font, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public void drawBar(GuiGraphics guiGraphics, int x, int y, int height, int value, int maxValue, int mouseX, int mouseY, Component tooltip) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        int draw = (int)((double)value / (double)maxValue * (double)(height - 2));
        guiGraphics.blit(this.resourceLocation, x, y, 1.0f, 150.0f, 13, height, 256, 256);
        guiGraphics.blit(this.resourceLocation, x + 1, y + height - draw - 1, 14.0f, 150.0f, 12, draw, 256, 256);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.mc.font, tooltip, mouseX, mouseY);
        }
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public ChatFormatting getPercentageColour(int percentage) {
        if (percentage <= 10) {
            return ChatFormatting.RED;
        }
        if (percentage >= 75) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.YELLOW;
    }

    public int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }
}

