/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.containers;

import net.creeperhost.polylib.data.DataManagerBlock;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface DataManagerContainer {
    public <T extends BlockEntity> T getBlockEntity();

    default public void handlePacketFromClient(ServerPlayer player, FriendlyByteBuf buf) {
        int containerId = buf.readVarInt();
        if (containerId != ((AbstractContainerMenu)this).containerId) {
            return;
        }
        int packetID = buf.readVarInt();
        ((DataManagerBlock)this.getBlockEntity()).handlePacketFromClient(player, packetID, buf);
    }

    default public void handleDataValueFromClient(ServerPlayer player, FriendlyByteBuf buf) {
        int containerId = buf.readVarInt();
        if (containerId != ((AbstractContainerMenu)this).containerId) {
            return;
        }
        ((DataManagerBlock)this.getBlockEntity()).getDataManager().handleSyncFromClient(player, buf);
    }
}

