/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class DoubleData
extends AbstractDataStore<Double> {
    public DoubleData() {
        super(0.0);
    }

    public DoubleData(double defaultValue) {
        super(defaultValue);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(((Double)this.value).doubleValue());
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.value = this.validValue(buf.readDouble(), (Double)this.value);
    }

    @Override
    public Tag toTag() {
        return DoubleTag.valueOf((double)((Double)this.value));
    }

    @Override
    public void fromTag(Tag tag) {
        this.value = this.validValue(((NumericTag)tag).getAsDouble(), (Double)this.value);
    }

    public double add(double add) {
        return this.set((Double)this.get() + add);
    }

    public double subtract(double subtract) {
        return this.set((Double)this.get() - subtract);
    }

    public double multiply(double multiplyBy) {
        return this.set((Double)this.get() * multiplyBy);
    }

    public double divide(double divideBy) {
        return this.set((Double)this.get() / divideBy);
    }

    public double zero() {
        return this.set(0.0);
    }

    public double inc() {
        return this.add(1.0);
    }

    public double dec() {
        return this.subtract(1.0);
    }
}

