/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class FloatData
extends AbstractDataStore<Float> {
    public FloatData() {
        super(Float.valueOf(0.0f));
    }

    public FloatData(float defaultValue) {
        super(Float.valueOf(defaultValue));
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(((Float)this.value).floatValue());
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.value = this.validValue(Float.valueOf(buf.readFloat()), (Float)this.value);
    }

    @Override
    public Tag toTag() {
        return FloatTag.valueOf((float)((Float)this.value).floatValue());
    }

    @Override
    public void fromTag(Tag tag) {
        this.value = this.validValue(Float.valueOf(((NumericTag)tag).getAsFloat()), (Float)this.value);
    }

    public float add(float add) {
        return this.set(Float.valueOf(((Float)this.get()).floatValue() + add)).floatValue();
    }

    public float subtract(float subtract) {
        return this.set(Float.valueOf(((Float)this.get()).floatValue() - subtract)).floatValue();
    }

    public float multiply(float multiplyBy) {
        return this.set(Float.valueOf(((Float)this.get()).floatValue() * multiplyBy)).floatValue();
    }

    public float divide(float divideBy) {
        return this.set(Float.valueOf(((Float)this.get()).floatValue() / divideBy)).floatValue();
    }

    public float zero() {
        return this.set(Float.valueOf(0.0f)).floatValue();
    }

    public float inc() {
        return this.add(1.0f);
    }

    public float dec() {
        return this.subtract(1.0f);
    }
}

