/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class StackData
extends AbstractDataStore<ItemStack> {
    public StackData() {
        super(ItemStack.EMPTY);
    }

    public StackData(ItemStack defaultValue) {
        super(defaultValue);
    }

    @Override
    public ItemStack set(ItemStack value) {
        if (!ItemStack.matches((ItemStack)value, (ItemStack)((ItemStack)this.value)) && this.validator.test(value)) {
            this.value = value.copy();
            this.markDirty();
        }
        return (ItemStack)this.value;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeItem((ItemStack)this.value);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.value = this.validValue(buf.readItem(), (ItemStack)this.value);
    }

    @Override
    public Tag toTag() {
        return ((ItemStack)this.value).save(new CompoundTag());
    }

    @Override
    public void fromTag(Tag tag) {
        this.value = this.validValue(ItemStack.of((CompoundTag)((CompoundTag)tag)), (ItemStack)this.value);
    }

    @Override
    public boolean isSameValue(ItemStack newValue) {
        return ItemStack.matches((ItemStack)((ItemStack)this.value), (ItemStack)newValue);
    }
}

