/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.helpers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class LevelHelper {
    public static AABB getAABBbox(BlockPos pos, Direction direction, int depth) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> new AABB((double)(pos.getX() - depth), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)pos.getX(), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
            case Direction.WEST -> new AABB((double)pos.getX(), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)(pos.getX() + depth), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
            case Direction.UP -> new AABB((double)(pos.getX() - 1), (double)(pos.getY() - depth), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)pos.getY(), (double)(pos.getZ() + 1));
            case Direction.DOWN -> new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + depth), (double)(pos.getZ() + 1));
            case Direction.SOUTH -> new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)(pos.getZ() - depth), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)pos.getZ());
            case Direction.NORTH -> new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + depth));
        };
    }

    public static Iterable<BlockPos> getPositionsFromBox(AABB box) {
        return LevelHelper.getPositionsFromBox(new BlockPos((int)box.minX, (int)box.minY, (int)box.minZ), new BlockPos((int)box.maxX, (int)box.maxY, (int)box.maxZ));
    }

    public static Iterable<BlockPos> getPositionsFromBox(BlockPos corner1, BlockPos corner2) {
        return () -> BlockPos.betweenClosedStream((BlockPos)corner1, (BlockPos)corner2).iterator();
    }

    public static boolean isAir(Level level, BlockPos blockPos) {
        if (level == null) {
            return false;
        }
        if (level.getBlockState(blockPos) == null) {
            return true;
        }
        if (level.getBlockState(blockPos).isAir()) {
            return true;
        }
        return level.getBlockState(blockPos).getBlock() == Blocks.AIR;
    }
}

