/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.energy.impl;

import net.creeperhost.polylib.inventory.energy.EnergySnapshot;
import net.creeperhost.polylib.inventory.energy.PolyEnergyContainer;
import net.creeperhost.polylib.inventory.energy.impl.SimpleEnergySnapshot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class SimpleEnergyContainer
implements PolyEnergyContainer {
    private final long capacity;
    private long energy;

    public SimpleEnergyContainer(long maxCapacity) {
        this.capacity = maxCapacity;
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        long inserted = Mth.clamp((long)maxAmount, (long)0L, (long)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        long extracted = Mth.clamp((long)maxAmount, (long)0L, (long)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    @Override
    public long internalInsert(long maxAmount, boolean simulate) {
        return this.insertEnergy(maxAmount, simulate);
    }

    @Override
    public long internalExtract(long maxAmount, boolean simulate) {
        return this.extractEnergy(maxAmount, simulate);
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = energy;
    }

    @Override
    public long getStoredEnergy() {
        return this.energy;
    }

    @Override
    public long getMaxCapacity() {
        return this.capacity;
    }

    @Override
    public long maxInsert() {
        return 1024L;
    }

    @Override
    public long maxExtract() {
        return 1024L;
    }

    @Override
    public CompoundTag serialize(CompoundTag root) {
        CompoundTag tag = root.getCompound("polylib");
        tag.putLong("Energy", this.energy);
        root.put("polylib", (Tag)tag);
        return root;
    }

    @Override
    public void deserialize(CompoundTag root) {
        CompoundTag tag = root.getCompound("polylib");
        this.energy = tag.getLong("Energy");
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    public void clearContent() {
        this.energy = 0L;
    }
}

