/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.items;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.creeperhost.polylib.Serializable;
import net.creeperhost.polylib.inventory.items.ContainerHelpers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BlockInventory
implements Container,
Serializable,
ContainerHelpers {
    private final BlockEntity blockEntity;
    private final Predicate<Player> canPlayerUse = player -> this.getBlockEntity().getBlockPos().distSqr((Vec3i)player.blockPosition()) <= 64.0;
    private BiPredicate<Integer, ItemStack> stackValidator = null;
    private Map<Integer, Predicate<ItemStack>> slotValidators = new HashMap<Integer, Predicate<ItemStack>>();
    private final NonNullList<ItemStack> items;
    private int maxStackSize = 64;

    public BlockInventory(BlockEntity blockEntity, int size) {
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.blockEntity = blockEntity;
    }

    public BlockInventory setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public BlockInventory setStackValidator(BiPredicate<Integer, ItemStack> stackValidator) {
        this.stackValidator = stackValidator;
        return this;
    }

    public BlockInventory setStackValidator(Predicate<ItemStack> stackValidator) {
        this.stackValidator = (integer, stack) -> stackValidator.test((ItemStack)stack);
        return this;
    }

    public BlockInventory setSlotValidator(int slot, Predicate<ItemStack> validator) {
        this.slotValidators.put(slot, validator);
        return this;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.items, (int)i);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void setChanged() {
        this.blockEntity.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return this.canPlayerUse.test(player);
    }

    public void clearContent() {
        this.items.clear();
    }

    @Override
    public void deserialize(CompoundTag compoundTag) {
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items);
    }

    @Override
    public CompoundTag serialize(CompoundTag compoundTag) {
        return ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items);
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (this.slotValidators.containsKey(slot)) {
            return this.slotValidators.get(slot).test(stack);
        }
        return this.stackValidator == null || this.stackValidator.test(slot, stack);
    }
}

