/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.power;

import net.creeperhost.polylib.Serializable;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class PolyEnergyStorage
implements IPolyEnergyStorage,
Serializable {
    protected Runnable changeListener;
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    protected boolean allowExtract = true;
    protected boolean allowReceive = true;

    public PolyEnergyStorage(long capacity) {
        this(capacity, capacity);
    }

    public PolyEnergyStorage(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public PolyEnergyStorage(long capacity, long maxReceive, long maxExtract) {
        this(capacity, maxReceive, maxExtract, null);
    }

    public PolyEnergyStorage(long capacity, long maxReceive, long maxExtract, Runnable changeListener) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.changeListener = changeListener;
    }

    public PolyEnergyStorage setIOMode(boolean allowExtract, boolean allowReceive) {
        this.allowExtract = allowExtract;
        this.allowReceive = allowReceive;
        return this;
    }

    public PolyEnergyStorage setExtractOnly() {
        return this.setIOMode(true, false);
    }

    public PolyEnergyStorage setReceiveOnly() {
        return this.setIOMode(false, true);
    }

    public PolyEnergyStorage setIOMode(boolean inputOutput) {
        return this.setIOMode(!inputOutput, inputOutput);
    }

    public PolyEnergyStorage setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public PolyEnergyStorage setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public PolyEnergyStorage setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public PolyEnergyStorage setMaxTransfer(long maxTransfer) {
        this.maxReceive = this.maxExtract = maxTransfer;
        return this;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(this.maxReceive(), maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            if (energyReceived != 0L) {
                this.markDirty();
            }
        }
        return energyReceived;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract(), maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            if (energyExtracted != 0L) {
                this.markDirty();
            }
        }
        return energyExtracted;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return this.allowExtract && this.maxExtract() > 0L;
    }

    @Override
    public boolean canReceive() {
        return this.allowReceive && this.maxReceive() > 0L;
    }

    public long maxExtract() {
        return this.maxExtract;
    }

    public long maxReceive() {
        return this.maxReceive;
    }

    @Override
    public long modifyEnergyStored(long amount) {
        if (amount > this.getMaxEnergyStored() - this.energy) {
            amount = this.getMaxEnergyStored() - this.energy;
        } else if (amount < -this.energy) {
            amount = -this.energy;
        }
        this.energy += amount;
        if (amount != 0L) {
            this.markDirty();
        }
        return Math.abs(amount);
    }

    public void markDirty() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        nbt.putLong("energy", this.energy);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.energy = nbt.getLong("energy");
    }

    public void readFromBuf(FriendlyByteBuf buf) {
        buf.writeVarLong(this.energy);
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        this.energy = buf.readVarLong();
    }
}

