/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.neoforge;

import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.inventory.energy.PolyEnergyItem;
import net.creeperhost.polylib.inventory.fluid.PolyFluidBlock;
import net.creeperhost.polylib.inventory.item.ItemInventoryBlock;
import net.creeperhost.polylib.inventory.items.PolyInventoryBlock;
import net.creeperhost.polylib.inventory.power.PolyEnergyBlock;
import net.creeperhost.polylib.neoforge.NeoForgeClientEvents;
import net.creeperhost.polylib.neoforge.inventory.energy.NeoForgeEnergyContainer;
import net.creeperhost.polylib.neoforge.inventory.energy.NeoForgeItemEnergyContainer;
import net.creeperhost.polylib.neoforge.inventory.fluid.PolyNeoFluidWrapper;
import net.creeperhost.polylib.neoforge.inventory.item.ItemContainerWrapper;
import net.creeperhost.polylib.neoforge.inventory.item.PolyInvWrapper;
import net.creeperhost.polylib.neoforge.inventory.power.PolyNeoEnergyWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.DistExecutor;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

@Mod(value="polylib")
public class PolyLibNeoForge {
    public PolyLibNeoForge(IEventBus modEventBus) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> NeoForgeClientEvents::init);
        PolyLib.init();
        modEventBus.addListener(EventPriority.LOWEST, this::registerCapabilities);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        PolyLib.LOGGER.info("=====Registering Capabilities=====");
        for (Item item : BuiltInRegistries.ITEM) {
            Object polyEnergyItem;
            if (item instanceof PolyEnergyItem) {
                polyEnergyItem = (PolyEnergyItem)item;
                PolyLib.LOGGER.info("Adding EnergyStore Item to " + item.getDescription().getString());
                event.registerItem(Capabilities.EnergyStorage.ITEM, (arg_0, arg_1) -> PolyLibNeoForge.lambda$registerCapabilities$1((PolyEnergyItem)polyEnergyItem, arg_0, arg_1), new ItemLike[]{item});
            }
            if (!(item instanceof net.creeperhost.polylib.inventory.power.PolyEnergyItem)) continue;
            polyEnergyItem = (net.creeperhost.polylib.inventory.power.PolyEnergyItem)item;
            PolyLib.LOGGER.info("Adding EnergyStore Item to " + item.getDescription().getString());
            event.registerItem(Capabilities.EnergyStorage.ITEM, (arg_0, arg_1) -> PolyLibNeoForge.lambda$registerCapabilities$2((net.creeperhost.polylib.inventory.power.PolyEnergyItem)polyEnergyItem, arg_0, arg_1), new ItemLike[]{item});
        }
        for (BlockEntityType blockEntityType : BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            try {
                BlockEntity dummy;
                ResourceLocation reg = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntityType);
                ModContainer mod = ModList.get().getModContainerById(reg.getNamespace()).orElse(null);
                if (mod == null || mod.getModInfo().getDependencies().stream().noneMatch(e -> e.getModId().equals("polylib")) || (dummy = blockEntityType.create(BlockPos.ZERO, Blocks.AIR.defaultBlockState())) == null) continue;
                if (dummy instanceof net.creeperhost.polylib.inventory.energy.PolyEnergyBlock) {
                    event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (entity, side) -> new NeoForgeEnergyContainer(((net.creeperhost.polylib.inventory.energy.PolyEnergyBlock)entity).getEnergyStorage(), (BlockEntity)entity));
                }
                if (dummy instanceof ItemInventoryBlock) {
                    event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, (entity, side) -> new ItemContainerWrapper(((ItemInventoryBlock)entity).getContainer((Direction)side)));
                }
                if (dummy instanceof PolyInventoryBlock) {
                    event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, (entity, side) -> new PolyInvWrapper(((PolyInventoryBlock)entity).getContainer((Direction)side)));
                }
                if (dummy instanceof PolyEnergyBlock) {
                    event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (entity, side) -> new PolyNeoEnergyWrapper(((PolyEnergyBlock)entity).getEnergyStorage((Direction)side)));
                }
                if (!(dummy instanceof PolyFluidBlock)) continue;
                event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, blockEntityType, (entity, side) -> new PolyNeoFluidWrapper(((PolyFluidBlock)entity).getFluidHandler((Direction)side)));
            }
            catch (Throwable throwable) {}
        }
    }

    private static /* synthetic */ IEnergyStorage lambda$registerCapabilities$2(net.creeperhost.polylib.inventory.power.PolyEnergyItem polyEnergyItem, ItemStack object, Void object2) {
        return new PolyNeoEnergyWrapper(polyEnergyItem.getEnergyStorage(object));
    }

    private static /* synthetic */ IEnergyStorage lambda$registerCapabilities$1(PolyEnergyItem polyEnergyItem, ItemStack object, Void object2) {
        return new NeoForgeItemEnergyContainer(polyEnergyItem.getEnergyStorage(object), object);
    }
}

