/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.neoforge.inventory.energy;

import net.creeperhost.polylib.Serializable;
import net.creeperhost.polylib.inventory.energy.PolyEnergyContainer;
import net.creeperhost.polylib.neoforge.AutoSerializable;
import net.creeperhost.polylib.util.Updatable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public record NeoForgeEnergyContainer<T extends PolyEnergyContainer & Updatable<BlockEntity>>(T container, BlockEntity entity) implements IEnergyStorage,
AutoSerializable
{
    public int receiveEnergy(int maxAmount, boolean bl) {
        if (maxAmount <= 0) {
            return 0;
        }
        int inserted = (int)this.container.insertEnergy(Math.min((long)maxAmount, this.container.maxInsert()), bl);
        ((Updatable)this.container).update(this.entity);
        return inserted;
    }

    public int extractEnergy(int maxAmount, boolean bl) {
        if (maxAmount <= 0) {
            return 0;
        }
        int extracted = (int)this.container.extractEnergy(Math.min((long)maxAmount, this.container.maxExtract()), bl);
        ((Updatable)this.container).update(this.entity);
        return extracted;
    }

    public int getEnergyStored() {
        return (int)this.container.getStoredEnergy();
    }

    public int getMaxEnergyStored() {
        return (int)this.container.getMaxCapacity();
    }

    public boolean canExtract() {
        return this.container.allowsExtraction();
    }

    public boolean canReceive() {
        return this.container.allowsInsertion();
    }

    @Override
    public Serializable getSerializable() {
        return this.container;
    }
}

