/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.neoforge.inventory.energy;

import net.creeperhost.polylib.inventory.energy.PlatformEnergyManager;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public record NeoForgeEnergyManager(IEnergyStorage energy) implements PlatformEnergyManager
{
    public NeoForgeEnergyManager(BlockEntity energyItem, Direction direction) {
        this((IEnergyStorage)energyItem.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, energyItem.getBlockPos(), (Object)direction));
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getEnergyStored();
    }

    @Override
    public long getCapacity() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public long extract(long amount, boolean simulate) {
        return this.energy.extractEnergy((int)amount, simulate);
    }

    @Override
    public long insert(long amount, boolean simulate) {
        return this.energy.receiveEnergy((int)amount, simulate);
    }

    @Override
    public boolean supportsInsertion() {
        return this.energy.canReceive();
    }

    @Override
    public boolean supportsExtraction() {
        return this.energy.canExtract();
    }
}

